/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="functional-test-per-metadata-category", name="One test per metadata category", description="Checks that there is one test case per class annotated as @MetaDataCategory and that its name ends with the suffix 'MetaDataTestCases' or 'MetaDataIT'.", priority=Priority.MAJOR, tags={"connector-certification"})
public class FunctionalTestPerMetadataCategoryCheck
extends BaseLoggingVisitor {
    public static final String KEY = "functional-test-per-metadata-category";
    public static final String TEST_DIR = "src/test/java";
    public static final Pattern TEST_PARENT_DIR_PATTERN = Pattern.compile("^((src/test/java/org/mule/module[s]?)+(/\\w+/)+(automation/functional)(/\\w+)*$)");

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
    }

    public final void visitClass(ClassTree tree) {
        for (AnnotationTree annotationTree : Iterables.filter((Iterable)tree.modifiers().annotations(), ClassParserUtils.ANNOTATION_TREE_PREDICATE)) {
            if (!ClassParserUtils.is(annotationTree, "org.mule.api.annotations.components.MetaDataCategory")) continue;
            File dir = new File(TEST_DIR);
            String categoryName = this.extractCategoryName(tree);
            List testFiles = (List)FileUtils.listFiles((File)dir, (IOFileFilter)new OrFileFilter((IOFileFilter)new WildcardFileFilter(categoryName + "MetaDataTestCases.java"), (IOFileFilter)new WildcardFileFilter(categoryName + "MetaDataIT.java")), (IOFileFilter)TrueFileFilter.INSTANCE);
            if (testFiles.size() != 1) {
                this.logAndRaiseIssue((Tree)tree.simpleName(), String.format("There should be one functional test per metadata category. Add test '%s' or '%s' for category '%s'.", categoryName + "MetaDataTestCases.java", categoryName + "MetaDataIT.java", tree.simpleName().name()));
                continue;
            }
            Matcher m = TEST_PARENT_DIR_PATTERN.matcher(((File)testFiles.get(0)).getParent());
            if (m.matches()) continue;
            this.logAndRaiseIssue((Tree)tree.simpleName(), String.format("'%s' must be placed under directory 'src/test/java/org/mule/modules/.../automation/functional'.", ((File)testFiles.get(0)).getName()));
        }
        super.visitClass(tree);
    }

    private String extractCategoryName(ClassTree tree) {
        String categoryName = tree.simpleName().name();
        return categoryName.replace("MetaData", "").replace("Metadata", "");
    }
}

