/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="no-assertions-in-before-or-after", name="No assertions allowed in methods annotated with @After or @Before.", description="Assertions are meant to be used in tests, not during setup of tear down of the test objects.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class NoAssertionsInBeforeOrAfterCheck
extends BaseLoggingVisitor {
    public static final String KEY = "no-assertions-in-before-or-after";

    public final boolean isAnnotatedWithBeforeOrAfter(MethodTree tree) {
        return Iterables.any((Iterable)tree.modifiers().annotations(), (Predicate)Predicates.or(ClassParserUtils.hasAnnotationPredicate("org.junit.After"), ClassParserUtils.hasAnnotationPredicate("org.junit.Before")));
    }

    public void visitMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && this.isAnnotatedWithBeforeOrAfter(methodTree)) {
            block.accept((TreeVisitor)new AssertionsVisitor());
        }
    }

    private class AssertionsVisitor
    extends BaseTreeVisitor {
        private AssertionsVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            IdentifierTree identifier = tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)tree.methodSelect()).identifier() : (IdentifierTree)tree.methodSelect();
            if (identifier.name().startsWith("assert")) {
                NoAssertionsInBeforeOrAfterCheck.this.logAndRaiseIssue((Tree)tree, "No assertions allowed in methods annotated with @After or @Before.");
            }
            super.visitMethodInvocation(tree);
        }
    }
}

