/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="test-cases-extend-abstract-test-cases", name="TestCases classes should inherit from CTF's AbstractTestCase class", description="Test Cases should inherit from CTF's AbstractTestCase class", priority=Priority.CRITICAL, tags={"connector-certification"})
public class TestCasesExtendAbstractTestCasesCheck
extends BaseLoggingVisitor {
    public static final String KEY = "test-cases-extend-abstract-test-cases";

    public final void visitClass(ClassTree classTree) {
        super.visitClass(classTree);
        Symbol owner = classTree.symbol().owner();
        boolean isFunctional = owner.isPackageSymbol() && owner.name().contains(".functional");
        boolean isTestClass = ClassParserUtils.isTestClass(classTree);
        if (isTestClass && isFunctional && classTree.simpleName() != null && !classTree.simpleName().name().endsWith("MetaDataTestCases") && !classTree.simpleName().name().endsWith("MetaDataIT") && !classTree.symbol().type().isSubtypeOf("org.mule.tools.devkit.ctf.junit.AbstractTestCase")) {
            this.logAndRaiseIssue((Tree)classTree, String.format("Test case '%s' should inherit from AbstractTestCase.", classTree.simpleName().name()));
        }
    }
}

