/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorCategory;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="license-declaration-files", name="License files should be present", description="There should exist 2 files named LICENSE_HEADER.txt and LICENSE.md, and they should have the right content depending on the connector category", priority=Priority.BLOCKER, tags={"connector-certification"})
public class LicenseDeclarationFilesCheck
implements StructureCheck {
    public static final String KEY = "license-declaration-files";
    private static final String LICENSE_FILE = "LICENSE.md";
    private static final String LICENSE_HEADER_FILE = "LICENSE_HEADER.txt";
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("[\\w']+");
    private final FileSystem fileSystem;

    public LicenseDeclarationFilesCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        ConnectorCategory category = PomUtils.category(mavenProject);
        this.checkLicenseFileContent(issues, category);
        return issues;
    }

    private void checkLicenseFileContent(List<ConnectorIssue> issues, ConnectorCategory category) {
        switch (category) {
            case COMMUNITY: 
            case SELECT: 
            case CERTIFIED: 
            case STANDARD: {
                this.checkLicenseFileContent(category, issues, LICENSE_FILE);
                this.checkLicenseFileContent(category, issues, LICENSE_HEADER_FILE);
                break;
            }
            case PREMIUM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector category: " + (Object)((Object)category));
            }
        }
    }

    private void checkLicenseFileContent(ConnectorCategory category, List<ConnectorIssue> issues, String fileName) {
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        String masterFileName = String.format("%s.%s", fileName, category.name().toLowerCase());
        Path path = this.fileSystem.baseDir().toPath().resolve(fileName);
        if (!Files.exists(path, new LinkOption[0])) {
            issues.add(new ConnectorIssue(KEY, String.format("File '%s' is missing. Please add a license file.", fileName)));
        } else {
            try {
                String connectorText = FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8);
                String masterText = Resources.toString((URL)this.getClass().getResource(masterFileName), (Charset)StandardCharsets.UTF_8).replace("${current_year}", yearFormat.format(new Date()));
                if (connectorText.contains("${current_year}")) {
                    issues.add(new ConnectorIssue(KEY, String.format("License file '%s' contains text '${current_year}'. It should have a resolved date not a variable.", fileName)));
                }
                List<String> masterTokens = this.getTokens(masterText);
                List<String> connectorTokens = this.getTokens(connectorText);
                if (connectorTokens.size() < masterTokens.size()) {
                    issues.add(new ConnectorIssue(KEY, String.format("Difference in license file '%s'. Content is shorter than expected. Please use the base template: %s.", fileName, masterFileName)));
                } else {
                    this.checkFileContent(issues, fileName, masterFileName, masterTokens, connectorTokens);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("Problem reading file: %s", fileName), (Throwable)e);
                issues.add(new ConnectorIssue(KEY, String.format("Problem reading license file: '%s'.", fileName)));
            }
        }
    }

    private void checkFileContent(List<ConnectorIssue> issues, String fileName, String masterFileName, List<String> masterTokens, List<String> connectorTokens) {
        int i;
        for (i = 0; i < masterTokens.size() && masterTokens.get(i).equals(connectorTokens.get(i)); ++i) {
        }
        if (i < masterTokens.size()) {
            issues.add(new ConnectorIssue(KEY, String.format("Difference in license file '%s'. Found word '%s' where '%s' was expected. Please use the base template: %s", fileName, connectorTokens.get(i), masterTokens.get(i), masterFileName)));
        }
    }

    private List<String> getTokens(String text) {
        Matcher matcher = TOKENIZER_PATTERN.matcher(text);
        ArrayList tokens = Lists.newArrayList();
        while (matcher.find()) {
            tokens.add(text.substring(matcher.start(), matcher.end()));
        }
        return tokens;
    }
}

