/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public final class ClassParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassParserUtils.class);
    public static final String FQN_DEFAULT = "org.mule.api.annotations.param.Default";
    public static final String FQN_OPTIONAL = "org.mule.api.annotations.param.Optional";
    public static final String FQN_REFONLY = "org.mule.api.annotations.param.RefOnly";
    private static final Set<String> allowedComplexTypes = ImmutableSet.builder().add((Object)Integer.class.getName()).add((Object)Double.class.getName()).add((Object)Long.class.getName()).add((Object)Float.class.getName()).add((Object)Character.class.getName()).add((Object)Byte.class.getName()).add((Object)Short.class.getName()).add((Object)Boolean.class.getName()).add((Object)BigDecimal.class.getName()).add((Object)String.class.getName()).add((Object)Enum.class.getName()).add((Object)Date.class.getName()).add((Object)Calendar.class.getName()).add((Object)"org.mule.api.MuleMessage").add((Object)"org.mule.api.MuleEvent").add((Object)"javax.xml.stream.XMLStreamReader").build();
    private static final Set<String> parameterizableTypes = ImmutableSet.builder().add((Object)List.class.getName()).add((Object)Map.class.getName()).build();
    private static final Set<String> connectionConfigTypes = ImmutableSet.builder().add((Object)"Configuration").add((Object)"ConnectionManagement").add((Object)"OAuth").add((Object)"OAuth2").build();
    public static final Predicate<AnnotationTree> ANNOTATION_TREE_PREDICATE = new Predicate<AnnotationTree>(){

        public boolean apply(@Nullable AnnotationTree input) {
            return input != null && input.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER});
        }
    };

    private ClassParserUtils() {
    }

    public static Predicate<VariableTree> complexTypePredicate() {
        return new Predicate<VariableTree>(){

            public boolean apply(@Nullable VariableTree input) {
                return input != null && !ClassParserUtils.isSimpleType(input.type());
            }
        };
    }

    public static Predicate<VariableTree> simpleTypePredicate() {
        return new Predicate<VariableTree>(){

            public boolean apply(@Nullable VariableTree input) {
                return input != null && ClassParserUtils.isSimpleType(input.type());
            }
        };
    }

    public static Predicate<AnnotationTree> hasAnnotationPredicate(final String annotationClassName) {
        return new Predicate<AnnotationTree>(){

            public boolean apply(@Nullable AnnotationTree input) {
                return input != null && ClassParserUtils.is(input, annotationClassName);
            }
        };
    }

    public static Predicate<AnnotationTree> hasSimpleAnnotationPredicate(final String annotationName) {
        return new Predicate<AnnotationTree>(){

            public boolean apply(@Nullable AnnotationTree input) {
                return input != null && ClassParserUtils.isSimpleName(input, annotationName);
            }
        };
    }

    public static Predicate<AnnotationTree> hasConfigAnnotationPredicate() {
        return new Predicate<AnnotationTree>(){

            public boolean apply(@Nullable AnnotationTree input) {
                if (input == null) {
                    return false;
                }
                String name = input.annotationType().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)input.annotationType()).identifier().name() : ((IdentifierTree)input.annotationType()).name();
                return connectionConfigTypes.contains(name);
            }
        };
    }

    public static boolean isSimpleType(@NotNull TypeTree type) {
        ParameterizedTypeTree parametrizedType;
        Type symbolType = type.symbolType();
        boolean result = symbolType.isPrimitive() || symbolType.symbol().isEnum() ? true : (type.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) ? parameterizableTypes.contains((parametrizedType = (ParameterizedTypeTree)type).type().symbolType().fullyQualifiedName()) && Iterables.all((Iterable)parametrizedType.typeArguments(), ClassParserUtils.simpleTypeCategoryPredicate()) : symbolType.isClass() && allowedComplexTypes.contains(symbolType.fullyQualifiedName()));
        logger.debug("Type '{}' is a simple type -> '{}'", (Object)type.toString(), (Object)result);
        return result;
    }

    public static boolean is(@NotNull AnnotationTree annotation, @NotNull Class<?> annotationClass) {
        String annotationSimpleName = annotation.annotationType().toString();
        return annotationSimpleName.equals(annotationClass.getSimpleName()) || annotationSimpleName.equals(annotationClass.getCanonicalName());
    }

    public static boolean is(@NotNull AnnotationTree annotation, @NotNull String annotationClassName) {
        String annotationSimpleName = ClassParserUtils.getNameForSimpleAndFQN(annotation);
        return annotationSimpleName.equals(annotationClassName) || annotationSimpleName.equals(annotationClassName.substring(annotationClassName.lastIndexOf(".") + 1));
    }

    public static boolean isSimpleName(@NotNull AnnotationTree annotation, @NotNull String annotationName) {
        String annotationSimpleName = annotation.annotationType().toString();
        return annotationSimpleName.equalsIgnoreCase(annotationName);
    }

    public static String getNameForSimpleAndFQN(@NotNull AnnotationTree annotation) {
        return annotation.annotationType().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)annotation.annotationType()).identifier().name() : annotation.annotationType().toString();
    }

    public static String getStringForType(TypeTree type) {
        StringBuilder sb = new StringBuilder();
        if (type.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            ParameterizedTypeTree parametrizedType = (ParameterizedTypeTree)type;
            sb.append(parametrizedType.type().toString());
            sb.append("<");
            sb.append(Joiner.on((String)", ").join(Iterables.transform((Iterable)parametrizedType.typeArguments(), ClassParserUtils.stringCategoryFunction())));
            sb.append(">");
        } else {
            sb.append(type.toString());
        }
        return sb.toString();
    }

    private static Function<Tree, String> stringCategoryFunction() {
        return new Function<Tree, String>(){

            public String apply(@Nullable Tree input) {
                if (input == null) {
                    return "[null]";
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return ClassParserUtils.getStringForType((TypeTree)input);
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD})) {
                    return "? extends " + ClassParserUtils.getStringForType(((WildcardTree)input).bound());
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.UNBOUNDED_WILDCARD})) {
                    return "?";
                }
                return "UNKNOWN";
            }
        };
    }

    private static Predicate<Tree> simpleTypeCategoryPredicate() {
        return new Predicate<Tree>(){

            public boolean apply(@Nullable Tree input) {
                if (input == null) {
                    return false;
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    return ClassParserUtils.isSimpleType((TypeTree)input);
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.EXTENDS_WILDCARD})) {
                    return ClassParserUtils.isSimpleType(((WildcardTree)input).bound());
                }
                if (input.is(new Tree.Kind[]{Tree.Kind.UNBOUNDED_WILDCARD})) {
                    return false;
                }
                return false;
            }
        };
    }

    public static boolean isTestClass(ClassTree classTree) {
        return Iterables.any((Iterable)classTree.members(), (Predicate)new Predicate<Tree>(){

            public boolean apply(@Nullable Tree input) {
                return input != null && input.is(new Tree.Kind[]{Tree.Kind.METHOD}) && Iterables.any((Iterable)((MethodTree)input).modifiers().annotations(), ClassParserUtils.hasAnnotationPredicate("org.junit.Test"));
            }
        });
    }

    public static String concatenate(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return "";
        }
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

