/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.git;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.mule.tools.devkit.sonar.checks.git.GitCheck;
import org.mule.tools.devkit.sonar.checks.git.PatternValidationPredicate;
import org.mule.tools.devkit.sonar.checks.git.RemoveRegexFunction;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.rule.RuleKey;

public abstract class GitIgnoreValidationCheck
implements GitCheck {
    private final String key;
    private final String messageTemplate;
    private final List<String> patterns;

    public GitIgnoreValidationCheck(String key, String messageTemplate, String ... patterns) {
        this.key = key;
        this.messageTemplate = messageTemplate;
        this.patterns = Lists.newArrayList((Object[])patterns);
    }

    @Override
    public void analyse(SensorContext context, InputFile inputFile) {
        for (String pattern : Iterables.transform((Iterable)Iterables.filter(this.patterns, (Predicate)Predicates.not((Predicate)new PatternValidationPredicate(inputFile.file()))), (Function)new RemoveRegexFunction())) {
            NewIssue issue = context.newIssue().forRule(RuleKey.of((String)"connector-certification-git", (String)this.key));
            issue.at(issue.newLocation().message(String.format(this.messageTemplate, pattern)).on((InputComponent)inputFile));
            issue.save();
        }
    }
}

