/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="number-of-complex-arguments", name="Too many complex-type arguments in a processor", description="Checks, for every @Processor, that the number of complex-type arguments is less than max allowed.", priority=Priority.MAJOR, tags={"connector-certification"})
public class NumberOfComplexArgumentsCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "number-of-complex-arguments";
    private static final int DEFAULT_MAX_ALLOWED = 6;
    @RuleProperty(key="maxArgumentsAllowed", defaultValue="6", description="The maximum number of complex-type arguments allowed in a method annotated with @Processor")
    protected int maxArgumentsAllowed = 6;

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        long count = Iterables.size((Iterable)Iterables.filter((Iterable)tree.parameters(), ClassParserUtils.complexTypePredicate()));
        if (count > (long)this.maxArgumentsAllowed) {
            String message = String.format("Processor '%s' has %d complex-type parameters (more than %d, which is the maximum allowed).", tree.simpleName(), count, this.maxArgumentsAllowed);
            this.logAndRaiseIssue((Tree)processorAnnotation, message);
        }
    }
}

