/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="refonly-annotation-in-complex-types", name="Complex-type arguments must be marked with @RefOnly", description="Checks that all complex-type arguments of a processor are annotated with @RefOnly.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class RefOnlyInComplexTypesCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "refonly-annotation-in-complex-types";

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        Iterable complexTypes = Iterables.filter((Iterable)tree.parameters(), ClassParserUtils.complexTypePredicate());
        for (VariableTree variable : complexTypes) {
            List annotations = variable.modifiers().annotations();
            long count = Iterables.size((Iterable)Iterables.filter((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.RefOnly")));
            if (count != 0L) continue;
            String message = String.format("Processor '%s' contains variable '%s' of type '%s' (complex type) not annotated with @RefOnly.", tree.simpleName(), variable.simpleName(), ClassParserUtils.getStringForType(variable.type()));
            this.logAndRaiseIssue((Tree)variable, message);
        }
    }
}

