/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.maven;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.exception.SonarCheckException;
import org.mule.tools.devkit.sonar.utils.NodeIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Version
implements Comparable<Version> {
    private final String value;
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("^(\\d(\\.\\d))(\\.\\d)?$");

    public Version(String value) {
        this.value = value;
    }

    public boolean isRevision() {
        return this.value.contains("-");
    }

    public static boolean hasValidFormat(String version) {
        return SEMANTIC_VERSION_PATTERN.matcher(version).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getLatestMinorDevKitVersion(String majorVersion) {
        try (InputStream xml = new URL("https://repository.mulesoft.org/nexus/content/repositories/releases/org/mule/tools/devkit/mule-devkit-parent/maven-metadata.xml").openStream();){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            doc.getDocumentElement().normalize();
            Version version2 = Lists.newArrayList((Iterable)new NodeIterable(doc.getElementsByTagName("version"))).stream().map(node -> (Short)Optional.ofNullable(node).map(Node::getNodeType).orElse(null) == 1 ? node.getFirstChild().getTextContent() : null).map(Version::new).filter(((Predicate<Version>)Version::isRevision).negate().and(version -> version.value.startsWith(majorVersion))).max((a, b) -> a.compareTo((Version)b)).orElse(null);
            return version2;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SonarCheckException("Unable to retrieve Devkit latest version.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.value != null ? this.value.equals(version.value) : version.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull Version version) {
        return this.value.compareTo(version.value);
    }
}

