/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="nullable-and-notnull-annotations", name="No @Nullable/@NotNull annotations should be used at processor level", description="If there is a parameter annotated with @NotNull (or @NonNull), remove the annotation. If there is a parameter annotated with @Nullable, replace it with @Optional annotation or remove it if @Optional is already present.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class AvoidNullChecksOnProcessorCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "nullable-and-notnull-annotations";
    private static final List<String> ANNOTATION_CLASSES = Lists.newArrayList((Object[])new String[]{"org.jetbrains.annotations.Nullable", "org.jetbrains.annotations.NotNull", "com.sun.javafx.beans.annotations.NonNull", "javax.annotation.Nonnull"});

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        for (VariableTree var : tree.parameters()) {
            List annotations = var.modifiers().annotations();
            for (String annotationClass : ANNOTATION_CLASSES) {
                for (AnnotationTree annotation : Iterables.filter((Iterable)annotations, ClassParserUtils.hasAnnotationPredicate(annotationClass))) {
                    this.logAndRaiseIssue((Tree)annotation, String.format("Remove @%s annotation in method '%s' argument '%s'.", annotationClass, tree.simpleName(), var.simpleName()));
                }
            }
        }
    }
}

