/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="base-connector-package", name="The connector base package should be org.mule.modules.XXXX, where XXXX is your connector name)", description="Connector code should be placed under org.mule.modules.XXXX package", priority=Priority.MAJOR, tags={"connector-certification"})
public class BasePackageCheck
extends BaseLoggingVisitor {
    public static final String KEY = "base-connector-package";

    public void visitClass(ClassTree classTree) {
        for (AnnotationTree annotationTree : Iterables.filter((Iterable)classTree.modifiers().annotations(), ClassParserUtils.ANNOTATION_TREE_PREDICATE)) {
            CompilationUnitTree compilationUnitTree;
            PackageDeclarationTree packageDeclarationTree;
            Tree parent;
            if (!ClassParserUtils.is(annotationTree, "org.mule.api.annotations.Connector") || (parent = classTree.parent()) == null || !parent.is(new Tree.Kind[]{Tree.Kind.COMPILATION_UNIT}) || (packageDeclarationTree = (compilationUnitTree = (CompilationUnitTree)parent).packageDeclaration()) == null) continue;
            String packageName = ClassParserUtils.concatenate(packageDeclarationTree.packageName());
            if (packageName.startsWith("org.mule.module.")) {
                this.logAndRaiseIssue((Tree)packageDeclarationTree, String.format("Connector base package found '%s'. Consider moving it to '%s'.", packageName, packageName.replaceFirst("module", "modules")));
                continue;
            }
            if (packageName.startsWith("org.mule.modules.")) continue;
            this.logAndRaiseIssue((Tree)packageDeclarationTree, String.format("Connector base package found '%s'. Connector's base package should be 'org.mule.modules.connectorname'.", packageName));
        }
        super.visitClass(classTree);
    }
}

