/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="functional-test-suite-coverage", name="Functional test coverage", description="Checks that: 1. There exists a @SuiteClasses annotation on Test Suite classes. 2. TestCases class names for processors end with 'TestCases'. 3. All test cases in each package (functional, system and unit) are included in their corresponding *TestSuite classes.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class FunctionalTestSuiteCheck
extends BaseLoggingVisitor {
    public static final String KEY = "functional-test-suite-coverage";
    public static final String SUFFIX = "TestCases";
    public static final String TEST_DIR = "src/test/java";
    public static final Pattern FILE_PATH_PATTERN = Pattern.compile("^((src/test/java/org/mule/module[s]?)+(/\\w+/)+(automation/functional/)+(\\w*.java)$)");

    public final void visitClass(ClassTree tree) {
        IdentifierTree treeName = tree.simpleName();
        if (treeName != null && treeName.name().equals("FunctionalTestSuite")) {
            AnnotationTree runWithAnnotation = (AnnotationTree)Iterables.find((Iterable)tree.modifiers().annotations(), ClassParserUtils.hasAnnotationPredicate("org.junit.runners.SuiteClasses"), null);
            if (runWithAnnotation == null) {
                this.logAndRaiseIssue((Tree)tree.simpleName(), String.format("Missing @SuiteClasses annotation on Test Suite class '%s'.", tree.simpleName().name()));
            } else {
                Arguments arguments = runWithAnnotation.arguments();
                ExpressionTree expressionTree = (ExpressionTree)Iterables.getOnlyElement((Iterable)arguments);
                if (expressionTree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
                    ListTree suiteClasses = ((NewArrayTree)expressionTree).initializers();
                    if (suiteClasses.isEmpty()) {
                        this.logAndRaiseIssue((Tree)runWithAnnotation, "No tests have been declared under @SuiteClasses.");
                    } else {
                        ArrayList tests = Lists.newArrayList((Iterable)FileUtils.listFiles((File)new File(TEST_DIR), (IOFileFilter)new WildcardFileFilter("*TestCases.java"), (IOFileFilter)TrueFileFilter.INSTANCE));
                        for (ExpressionTree test : suiteClasses) {
                            final String testName = ((IdentifierTree)((MemberSelectExpressionTree)test).expression()).name();
                            Iterable matchingTests = Iterables.filter((Iterable)tests, (Predicate)new Predicate<File>(){

                                public boolean apply(@Nullable File input) {
                                    return input != null && testName.equals(FilenameUtils.removeExtension((String)input.getName())) && FILE_PATH_PATTERN.matcher(input.getPath()).find();
                                }
                            });
                            if (testName.endsWith(SUFFIX)) {
                                if (!Iterables.isEmpty((Iterable)matchingTests)) continue;
                                this.logAndRaiseIssue((Tree)test, String.format("A file named '%s.java' must exist in directory 'src/test/java/.../automation/functional'.", testName));
                                continue;
                            }
                            this.logAndRaiseIssue((Tree)test, String.format("Functional test class name must end with 'TestCases'. Rename '%s.java' accordingly.", testName));
                        }
                    }
                }
            }
        }
        super.visitClass(tree);
    }
}

