/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="metadata-test-cases-extend-abstract-metadata-test-case", name="MetaDataTestCases classes should extend CTF's AbstractMetaDataTestCase class", description="MetaData Test Cases should extend CTFs AbstractMetaDataTestCase class", priority=Priority.CRITICAL, tags={"connector-certification"})
public class MetaDataTestCasesExtendAbstractMetaDataTestCaseCheck
extends BaseLoggingVisitor {
    public static final String KEY = "metadata-test-cases-extend-abstract-metadata-test-case";

    public final void visitClass(ClassTree classTree) {
        super.visitClass(classTree);
        Symbol owner = classTree.symbol().owner();
        boolean isFunctional = owner.isPackageSymbol() && owner.name().endsWith("functional");
        boolean isTestClass = ClassParserUtils.isTestClass(classTree);
        if (isTestClass && isFunctional && classTree.simpleName() != null && (classTree.simpleName().name().endsWith("MetaDataTestCases") || classTree.simpleName().name().endsWith("MetaDataTestCases")) && !classTree.symbol().type().isSubtypeOf("org.mule.tools.devkit.ctf.junit.AbstractMetaDataTestCase")) {
            this.logAndRaiseIssue((Tree)classTree, String.format("MetaData Test Case '%s' should inherit from AbstractMetaDataTestCase.", classTree.simpleName().name()));
        }
    }
}

