/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="number-of-simple-and-optional-arguments", name="Too many @Optional arguments in a processor", description="Checks, for every @Processor, that the number of optional arguments (each of which must be of simple-type) doesn't exceed the maximum allowed. If it does, the suggested approach is to wrap them all in a separate POJO class. ", priority=Priority.MAJOR, tags={"connector-certification"})
public class NumberOfSimpleAndOptionalArgumentsCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "number-of-simple-and-optional-arguments";
    private static final int DEFAULT_MAX_ALLOWED = 6;
    @RuleProperty(key="maxArgumentsAllowed", defaultValue="6", description="The maximum number of simple-type and optional arguments allowed in a method annotated with @Processor")
    protected int maxArgumentsAllowed = 6;

    @Override
    protected void verifyProcessor(@NotNull MethodTree tree, @NotNull IdentifierTree processorAnnotation) {
        long count = Iterables.size((Iterable)Iterables.filter((Iterable)tree.parameters(), (Predicate)Predicates.and(ClassParserUtils.simpleTypePredicate(), (Predicate)new Predicate<VariableTree>(){

            public boolean apply(@Nullable VariableTree input) {
                return input != null && Iterables.any((Iterable)input.modifiers().annotations(), ClassParserUtils.hasAnnotationPredicate("org.mule.api.annotations.param.Optional"));
            }
        })));
        if (count > (long)this.maxArgumentsAllowed) {
            String message = String.format("Processor '%s' has %d simple-type parameters marked as @Optional (more than %d, which is the maximum allowed). It's strongly recommended that all optional parameters are grouped inside a separate POJO class.", tree.simpleName(), count, this.maxArgumentsAllowed);
            this.logAndRaiseIssue((Tree)processorAnnotation, message);
        }
    }
}

