/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="redundant-exception-name", name="Redundant exception names thrown by a processor", description="Don't use the word 'Connector' to define the name of custom exceptions, e.g: <MyAwesomeConnectorException> should be <MyAwesomeException>.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class RedundantExceptionNameCheck
extends BaseLoggingVisitor {
    public static final String KEY = "redundant-exception-name";

    public void visitClass(ClassTree tree) {
        IdentifierTree className;
        Type superClassType;
        TypeTree superClassTree = tree.superClass();
        if (superClassTree != null && (superClassType = superClassTree.symbolType()).isSubtypeOf("java.lang.Exception") && (className = tree.simpleName()) != null && className.name().contains("Connector")) {
            this.logAndRaiseIssue((Tree)tree, String.format("Exception class '%s' should be renamed to '%s'.", className.name(), className.name().replace("Connector", "")));
        }
        super.visitClass(tree);
    }
}

