/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.maven;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.maven.MavenCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="distribution-management-by-category", name="Distribution Management must be properly configured in pom.xml", description="Checks that <distributionManagement> is declared in pom.xml and correctly configured (both <repository> and <snapshotRepository>) based on the connector category.", priority=Priority.BLOCKER, tags={"connector-certification"})
public class DistributionManagementByCategoryCheck
implements MavenCheck {
    public static final String KEY = "distribution-management-by-category";

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        String category = mavenProject.getProperties().getProperty("category");
        DistributionManagement distribution = mavenProject.getDistributionManagement();
        if (distribution == null) {
            this.logAndRaiseIssue(issues, "Distribution Management must be properly configured in pom.xml under a <distributionManagement> tag, according to connector category.");
        } else {
            DeploymentRepository deploymentRepository = distribution.getRepository();
            DeploymentRepository snapshotRepository = distribution.getSnapshotRepository();
            if (deploymentRepository == null) {
                this.logAndRaiseIssue(issues, "Distribution Management is missing required <repository> configuration.");
            } else if (snapshotRepository == null) {
                this.logAndRaiseIssue(issues, "Distribution Management is missing required <snapshotRepository> configuration.");
            } else {
                switch (category.toUpperCase()) {
                    case "PREMIUM": 
                    case "STANDARD": 
                    case "SELECT": 
                    case "CERTIFIED": {
                        this.checkPremiumOrSelectOrCertified(category, issues, deploymentRepository, snapshotRepository);
                        break;
                    }
                    case "COMMUNITY": {
                        this.checkCommunity(category, issues, deploymentRepository, snapshotRepository);
                        break;
                    }
                    default: {
                        this.logAndRaiseIssue(issues, "Invalid category specified in pom.xml");
                    }
                }
            }
        }
        return issues;
    }

    private void checkCommunity(String category, @NotNull List<ConnectorIssue> issues, @NotNull DeploymentRepository deployRepo, @NotNull DeploymentRepository snapshotRepo) {
        if (!this.hasDeployRepoId(deployRepo)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <repository> tag configured with <id>mulesoft-releases</id>.", category));
        }
        if (!this.hasDeployRepoUrl(deployRepo)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <repository> tag configured with <url>http://repository-master.mulesoft.org/releases/</url>.", category));
        }
        if (!this.hasSnapshotRepoId(snapshotRepo)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <id>mulesoft-snapshots</id>.", category));
        }
        if (!this.hasSnapshotRepoUrl(snapshotRepo)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <url>http://repository-master.mulesoft.org/releases/</url>.", category));
        }
        if (!this.hasSnapshotRepoUniqueVersion(snapshotRepo)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <uniqueVersion>false</uniqueVersion>. Default value is 'true'.", category));
        }
    }

    private void checkPremiumOrSelectOrCertified(String category, @NotNull List<ConnectorIssue> issues, @NotNull DeploymentRepository deployRepoEE, @NotNull DeploymentRepository snapshotRepoEE) {
        if (!this.hasDeployRepoEEId(deployRepoEE)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <repository> tag configured with <id>mulesoft-ee-releases</id>.", category));
        }
        if (!this.hasDeployRepoEEUrl(deployRepoEE)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <repository> tag configured with <url>https://repository-master.mulesoft.org/nexus/content/repositories/releases-ee/</url>.", category));
        }
        if (!this.hasSnapshotRepoEEId(snapshotRepoEE)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <id>mulesoft-ee-snapshots</id>.", category));
        }
        if (!this.hasSnapshotRepoEEUrl(snapshotRepoEE)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <url>repository-master.mulesoft.org/nexus/content/repositories/ci-snapshots/</url>.", category));
        }
        if (!this.hasSnapshotRepoUniqueVersion(snapshotRepoEE)) {
            this.logAndRaiseIssue(issues, String.format("%s connectors must have a <snapshotRepository> tag configured with <uniqueVersion>false</uniqueVersion>. Default value is 'true'.", category));
        }
    }

    private boolean hasDeployRepoId(DeploymentRepository deployRepo) {
        return deployRepo.getId().equals("mulesoft-releases");
    }

    private boolean hasDeployRepoUrl(DeploymentRepository deployRepo) {
        return deployRepo.getUrl().equals("http://repository-master.mulesoft.org/releases/");
    }

    private boolean hasSnapshotRepoId(DeploymentRepository snapshotRepo) {
        return snapshotRepo.getId().equals("mulesoft-snapshots");
    }

    private boolean hasSnapshotRepoUrl(DeploymentRepository snapshotRepo) {
        return snapshotRepo.getUrl().equals("http://repository-master.mulesoft.org/snapshots/");
    }

    private boolean hasSnapshotRepoUniqueVersion(DeploymentRepository snapshotRepo) {
        return !snapshotRepo.isUniqueVersion();
    }

    private boolean hasDeployRepoEEId(DeploymentRepository deployRepoEE) {
        return deployRepoEE.getId().equals("mule-ee-releases");
    }

    private boolean hasDeployRepoEEUrl(DeploymentRepository deployRepoEE) {
        return deployRepoEE.getUrl().equals("https://repository-master.mulesoft.org/nexus/content/repositories/releases-ee/");
    }

    private boolean hasSnapshotRepoEEId(DeploymentRepository snapshotRepoEE) {
        return snapshotRepoEE.getId().equals("mule-ee-snapshots");
    }

    private boolean hasSnapshotRepoEEUrl(DeploymentRepository snapshotRepoEE) {
        return snapshotRepoEE.getUrl().equals("https://repository-master.mulesoft.org/nexus/content/repositories/ci-snapshots/");
    }

    private final void logAndRaiseIssue(List<ConnectorIssue> issues, String message) {
        issues.add(new ConnectorIssue(KEY, message));
    }
}

