/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.maven;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.maven.MavenCheck;
import org.mule.tools.devkit.sonar.exception.SonarCheckException;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;

public class MavenSensor
implements Sensor {
    private Iterable<Class<?>> checks = new Reflections("org.mule.tools.devkit.sonar.checks.maven", new Scanner[0]).getTypesAnnotatedWith(Rule.class).stream().filter(arg_0 -> ((Predicate)Predicates.subtypeOf(MavenCheck.class)).apply(arg_0)).collect(Collectors.toList());

    public void describe(SensorDescriptor sensorDescriptor) {
    }

    public void execute(SensorContext sensorContext) {
        try {
            FileSystem fileSystem = sensorContext.fileSystem();
            MavenProject mavenProject = PomUtils.createMavenProjectFromPomFile(fileSystem.baseDir());
            if (PomUtils.isDevKitConnector(mavenProject)) {
                for (InputFile pomFile : fileSystem.inputFiles(fileSystem.predicates().matchesPathPattern("pom.xml"))) {
                    for (Class<?> mavenCheck : this.checks) {
                        Iterable<ConnectorIssue> analyse = ((MavenCheck)MavenCheck.class.cast(mavenCheck.newInstance())).analyze(mavenProject);
                        for (ConnectorIssue issue : analyse) {
                            this.logAndRaiseIssue(pomFile, issue, sensorContext);
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SonarCheckException(e);
        }
    }

    private void logAndRaiseIssue(InputFile pomFile, ConnectorIssue connectorIssue, SensorContext sensorContext) {
        NewIssue issue = sensorContext.newIssue().forRule(RuleKey.of((String)"connector-certification-mvn", (String)connectorIssue.ruleKey()));
        issue.at(issue.newLocation().message(connectorIssue.message()).on((InputComponent)pomFile));
        issue.save();
    }
}

