/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.maven;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.maven.MavenCheck;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="snapshot-dependencies-not-allowed", name="SNAPSHOT dependencies are NOT allowed in pom.xml", description="Checks that no SNAPSHOT versions are declared in pom.xml", priority=Priority.BLOCKER, tags={"connector-certification"})
public class SnapshotDependenciesCheck
implements MavenCheck {
    public static final String KEY = "snapshot-dependencies-not-allowed";

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        if (!mavenProject.getVersion().endsWith("SNAPSHOT")) {
            List dependencies;
            Parent parent = mavenProject.getModel().getParent();
            if (parent != null && PomUtils.hasSnapshot(parent.getVersion())) {
                issues.add(new ConnectorIssue(KEY, String.format("Project version is not a snapshot (%s), so it should not inherit from a snapshot version parent (%s:%s).", mavenProject.getVersion(), parent.getArtifactId(), parent.getVersion())));
            }
            if (mavenProject.getDependencies() != null && (dependencies = mavenProject.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    if (!PomUtils.hasSnapshot(dependency.getVersion())) continue;
                    issues.add(new ConnectorIssue(KEY, String.format("Project version is not a snapshot (%s), so it should not declare any snapshot dependencies (%s:%s).", mavenProject.getVersion(), dependency.getArtifactId(), dependency.getVersion())));
                }
            }
        }
        return issues;
    }
}

