/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.maven.MavenCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="source-deployment-for-standard-category", name="Source deployment for Standard connectors", description="Checks that the source code is not deployed when releasing a new version of a Standard connector. To prevent this, the 'maven-source-plugin' must be added to the pom.xml: \n``\n<build>\n\t<plugins>\n\t\t<plugin>\n\t\t\t<artifactId>maven-source-plugin</artifactId>\n\t\t    <version>2.4</version>\n\t\t    <executions>\n\t\t    \t<execution>\n\t\t        \t<id>attach-sources</id>\n\t\t            <phase>none</phase>\n\t\t        </execution>\n\t\t    </executions>\n\t\t</plugin>\n\t</plugins>\n<build>\n``\n\nIMPORTANT: since DevKit 3.7.2, the Standard category is no longer supported thus the connector should be migrated to either Premium, Select or Certified.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class SourceDeploymentForStandardCategoryCheck
implements MavenCheck {
    public static final String KEY = "source-deployment-for-standard-category";
    private static final String SOURCE_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String SOURCE_PLUGIN_ARTIFACT_ID = "maven-source-plugin";
    private static final String SOURCE_PLUGIN_PHASE_ID = "attach-sources";
    private static final String SOURCE_PLUGIN_PHASE_VALUE = "none";
    private static final Logger logger = LoggerFactory.getLogger(SourceDeploymentForStandardCategoryCheck.class);
    public static final Predicate<Plugin> HAS_SOURCE_PLUGIN = new Predicate<Plugin>(){

        public boolean apply(@Nullable Plugin input) {
            return input != null && input.getGroupId().equals(SourceDeploymentForStandardCategoryCheck.SOURCE_PLUGIN_GROUP_ID) && input.getArtifactId().equals(SourceDeploymentForStandardCategoryCheck.SOURCE_PLUGIN_ARTIFACT_ID) && Iterables.any((Iterable)input.getExecutions(), HAS_PHASE_NONE_EXECUTION);
        }
    };
    public static final Predicate<PluginExecution> HAS_PHASE_NONE_EXECUTION = new Predicate<PluginExecution>(){

        public boolean apply(@Nullable PluginExecution input) {
            return input != null && input.getId().equals(SourceDeploymentForStandardCategoryCheck.SOURCE_PLUGIN_PHASE_ID) && input.getPhase().equals(SourceDeploymentForStandardCategoryCheck.SOURCE_PLUGIN_PHASE_VALUE);
        }
    };

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        boolean hasSourcePlugin;
        ArrayList issues = Lists.newArrayList();
        String category = mavenProject.getProperties().getProperty("category");
        logger.debug("Parsed Category version -> {}", (Object)category);
        boolean bl = hasSourcePlugin = mavenProject.getBuild() != null && Iterables.any((Iterable)mavenProject.getBuildPlugins(), HAS_SOURCE_PLUGIN);
        if (category.equalsIgnoreCase("STANDARD") && !hasSourcePlugin) {
            issues.add(new ConnectorIssue(KEY, "Standard connectors must declare a 'maven-source-plugin' in pom.xml to prevent the deployment of its sources."));
        }
        return issues;
    }
}

