/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.ExistingResourceCheck;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="gitignore-exist", name=".gitignore should be present", description="There should exist a .gitignore file in root folder.", priority=Priority.CRITICAL, tags={"connector-certification"})
public class GitIgnoreExistsCheck
extends ExistingResourceCheck {
    public static final String KEY = "gitignore-exist";
    public static final String PATH = ".gitignore";

    public GitIgnoreExistsCheck(FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList(super.analyze(mavenProject));
        if (FileUtils.listFiles((File)this.getFileSystem().baseDir(), (IOFileFilter)new WildcardFileFilter(PATH), (IOFileFilter)TrueFileFilter.INSTANCE).size() > BigInteger.ONE.intValue()) {
            issues.add(new ConnectorIssue(KEY, "More than one .gitignore file in project."));
        }
        return issues;
    }

    @Override
    protected String resourcePath() {
        return PATH;
    }

    @Override
    protected String ruleKey() {
        return KEY;
    }
}

