/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="release-notes-exists", name="Release Notes should be present", description="There should exist a file named 'doc/release-notes.adoc'", priority=Priority.CRITICAL, tags={"connector-certification"})
public class ReleaseNotesExistsCheck
implements StructureCheck {
    public static final String KEY = "release-notes-exists";
    private static final String RELEASE_NOTES_FILE = "release-notes.adoc";
    public static final String DOC_FOLDER = "doc";
    private final FileSystem fileSystem;

    public ReleaseNotesExistsCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        Path path = this.fileSystem.baseDir().toPath().resolve(DOC_FOLDER).resolve(RELEASE_NOTES_FILE);
        if (!Files.exists(path, new LinkOption[0])) {
            issues.add(new ConnectorIssue(KEY, String.format("File %s is missing.", path.toFile().getName())));
        } else {
            try {
                long fileSize = Files.size(path);
                if (fileSize < 100L) {
                    issues.add(new ConnectorIssue(KEY, String.format("File %s found but doesn't have proper content (size: %s bytes).", path.toFile().getName(), fileSize)));
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("Problem reading file: %s", path.toFile().getName()), (Throwable)e);
                issues.add(new ConnectorIssue(KEY, String.format("Could not read file %s", path.toFile().getName())));
            }
        }
        return issues;
    }
}

