/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.collect.Lists;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.DemoExistCheck;
import org.mule.tools.devkit.sonar.checks.structure.GitIgnoreExistsCheck;
import org.mule.tools.devkit.sonar.checks.structure.IconsExistCheck;
import org.mule.tools.devkit.sonar.checks.structure.LicenseDeclarationFilesCheck;
import org.mule.tools.devkit.sonar.checks.structure.ReadmeExistsCheck;
import org.mule.tools.devkit.sonar.checks.structure.ReleaseNotesExistsCheck;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.mule.tools.devkit.sonar.checks.structure.TestDataBuilderExistsCheck;
import org.mule.tools.devkit.sonar.checks.structure.TestResourcesFolderExistsCheck;
import org.mule.tools.devkit.sonar.checks.structure.TestSuiteFoldersExistCheck;
import org.mule.tools.devkit.sonar.checks.structure.UserManualExistsCheck;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.rule.RuleKey;

public class StructureSensor
implements Sensor {
    private final FileSystem fileSystem;

    public StructureSensor(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private Iterable<StructureCheck> buildStructureChecks() {
        return Lists.newArrayList((Object[])new StructureCheck[]{new IconsExistCheck(this.fileSystem), new LicenseDeclarationFilesCheck(this.fileSystem), new ReadmeExistsCheck(this.fileSystem), new ReleaseNotesExistsCheck(this.fileSystem), new UserManualExistsCheck(this.fileSystem), new TestResourcesFolderExistsCheck(this.fileSystem), new TestSuiteFoldersExistCheck(this.fileSystem), new DemoExistCheck(this.fileSystem), new TestDataBuilderExistsCheck(this.fileSystem), new GitIgnoreExistsCheck(this.fileSystem)});
    }

    public void describe(SensorDescriptor sensorDescriptor) {
    }

    public void execute(SensorContext sensorContext) {
        MavenProject mavenProject = PomUtils.createMavenProjectFromPomFile(this.fileSystem.baseDir());
        if (PomUtils.isDevKitConnector(mavenProject)) {
            for (StructureCheck structureCheck : this.buildStructureChecks()) {
                Iterable<ConnectorIssue> analyse = structureCheck.analyze(mavenProject);
                for (ConnectorIssue issue : analyse) {
                    this.logAndRaiseIssue(issue, sensorContext);
                }
            }
        }
    }

    private void logAndRaiseIssue(ConnectorIssue connectorIssue, SensorContext sensorContext) {
        NewIssue issue = sensorContext.newIssue().forRule(RuleKey.of((String)"connector-certification-struct", (String)connectorIssue.ruleKey()));
        issue.at(issue.newLocation().message(connectorIssue.message()).on((InputComponent)sensorContext.project()));
        issue.save();
    }
}

