/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.WordUtils;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="test-suite-folders-exists", name="Test Suite directories must be present", description="There must exist 3 test suite directories: one for Functional ('automation/functional'), one for System ('automation/system') and one for Unit ('automation/unit').", priority=Priority.CRITICAL, tags={"connector-certification"})
public class TestSuiteFoldersExistCheck
implements StructureCheck {
    public static final String KEY = "test-suite-folders-exists";
    public static final ImmutableList<String> packages = ImmutableList.of((Object)"functional", (Object)"system", (Object)"unit");
    public static final Pattern TEST_PACKAGES_PATTERN = Pattern.compile("^((.*?)(org/mule/module[s]?)+(/\\w+/)+(automation/)+(functional|system|unit)$)");
    public static final Predicate<File> HAS_VALID_TEST_PACKAGE = new Predicate<File>(){

        public boolean apply(@Nullable File input) {
            return input != null && TEST_PACKAGES_PATTERN.matcher(input.getPath()).find();
        }
    };
    private final FileSystem fileSystem;

    public TestSuiteFoldersExistCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        File dir = this.fileSystem.baseDir();
        Collection directories = FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        Iterable suites = Iterables.filter((Iterable)directories, HAS_VALID_TEST_PACKAGE);
        for (String suite : packages) {
            if (Iterables.any((Iterable)suites, this.getPredicateForSuite(suite))) continue;
            issues.add(new ConnectorIssue(KEY, String.format("%s test suite directory doesn't exist.", WordUtils.capitalize((String)suite))));
        }
        return issues;
    }

    private Predicate<File> getPredicateForSuite(final String suite) {
        return new Predicate<File>(){

            public boolean apply(File input) {
                return input != null && input.getName().equals(suite);
            }
        };
    }
}

