/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;

public class ConnectorCertificationRulesDefinition
implements RulesDefinition {
    public static final String REPOSITORY_NAME = "Connector Certification M3";
    public static final String JAVA_LANGUAGE_KEY = "java";
    public static final String JAVA_REPOSITORY_KEY = "connector-certification-m3-java";

    public void define(RulesDefinition.Context context) {
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set rules = reflections.getTypesAnnotatedWith(Rule.class);
        this.addRules(context, JAVA_REPOSITORY_KEY, JAVA_LANGUAGE_KEY, rules.stream().filter(arg_0 -> ((Predicate)Predicates.subtypeOf(JavaCheck.class)).apply(arg_0)).collect(Collectors.toList()));
    }

    private void addRules(RulesDefinition.Context context, String key, String language, Iterable<Class<?>> rules) {
        RulesDefinition.NewRepository repo = context.createRepository(key, language);
        repo.setName(REPOSITORY_NAME);
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repo, (Class[])Iterables.toArray(rules, Class.class));
        repo.done();
    }
}

