/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import org.jetbrains.annotations.NotNull;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;

public abstract class AbstractConnectorClassCheck
extends BaseLoggingVisitor {
    public final void visitClass(ClassTree tree) {
        for (AnnotationTree annotationTree : Iterables.filter((Iterable)tree.modifiers().annotations(), ClassParserUtils.ANNOTATION_TREE_PREDICATE)) {
            if (!ClassParserUtils.is(annotationTree, "org.mule.api.annotations.Connector")) continue;
            this.verifyConnector(tree);
        }
        super.visitClass(tree);
    }

    public final void visitMethod(MethodTree tree) {
        for (AnnotationTree annotationTree : Iterables.filter((Iterable)tree.modifiers().annotations(), ClassParserUtils.ANNOTATION_TREE_PREDICATE)) {
            IdentifierTree idf = (IdentifierTree)annotationTree.annotationType();
            if (ClassParserUtils.is(annotationTree, "org.mule.api.annotations.Processor")) {
                this.verifyProcessor(tree, idf);
                continue;
            }
            if (!ClassParserUtils.is(annotationTree, "org.mule.api.annotations.Source")) continue;
            this.verifySource(tree, idf);
        }
        super.visitMethod(tree);
    }

    protected void verifySource(@NotNull MethodTree methodTree, @NotNull IdentifierTree sourceAnnotation) {
    }

    protected void verifyProcessor(@NotNull MethodTree methodTree, @NotNull IdentifierTree processorAnnotation) {
    }

    protected void verifyConnector(@NotNull ClassTree classTree) {
    }
}

