/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.sonar.checks.ConnectorCategory;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.mule.tools.devkit.sonar.utils.PomUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="license-by-category", name="Licensing annotations must match the category declared in pom.xml", description="Checks the correct usage of @RequiresEnterpriseLicense and @RequiresEntitlement according to category defined in pom.xml.", priority=Priority.BLOCKER, tags={"connector-certification"})
public class LicenseByCategoryCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "license-by-category";
    public static final Predicate<AnnotationTree> HAS_REQUIRES_ENTERPRISE_LICENSE_ANNOTATION = new Predicate<AnnotationTree>(){

        public boolean apply(@Nullable AnnotationTree input) {
            return input != null && ClassParserUtils.is(input, "org.mule.api.annotations.licensing.RequiresEnterpriseLicense");
        }
    };
    public static final Predicate<AnnotationTree> HAS_REQUIRES_ENTITLEMENT_ANNOTATION = new Predicate<AnnotationTree>(){

        public boolean apply(@Nullable AnnotationTree input) {
            return input != null && ClassParserUtils.is(input, "org.mule.api.annotations.licensing.RequiresEntitlement");
        }
    };
    private final FileSystem fileSystem;

    public LicenseByCategoryCheck() {
        this.fileSystem = null;
    }

    @VisibleForTesting
    protected LicenseByCategoryCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    protected void verifyConnector(@NotNull ClassTree classTree) {
        MavenProject mavenProject = this.fileSystem != null ? PomUtils.createMavenProjectFromPomFile(this.fileSystem.baseDir()) : PomUtils.createMavenProjectFromPomFile(new File("."));
        ConnectorCategory category = PomUtils.category(mavenProject);
        List annotations = classTree.modifiers().annotations();
        boolean hasEnterpriseAnnotation = Iterables.any((Iterable)annotations, HAS_REQUIRES_ENTERPRISE_LICENSE_ANNOTATION);
        boolean hasEntitlementAnnotation = Iterables.any((Iterable)annotations, HAS_REQUIRES_ENTITLEMENT_ANNOTATION);
        switch (category) {
            case PREMIUM: {
                this.checkPremium(classTree, annotations, hasEnterpriseAnnotation, hasEntitlementAnnotation);
                break;
            }
            case STANDARD: 
            case SELECT: 
            case CERTIFIED: {
                this.checkSelectOrCertified(classTree, hasEnterpriseAnnotation, hasEntitlementAnnotation);
                break;
            }
            case COMMUNITY: {
                this.checkCommunity(classTree, hasEnterpriseAnnotation, hasEntitlementAnnotation);
                break;
            }
            default: {
                this.logAndRaiseIssue((Tree)classTree.simpleName(), "Invalid category specified in pom.xml");
            }
        }
    }

    private void checkCommunity(@NotNull ClassTree classTree, boolean hasEnterpriseAnnotation, boolean hasEntitlementAnnotation) {
        if (hasEnterpriseAnnotation || hasEntitlementAnnotation) {
            this.logAndRaiseIssue((Tree)classTree.simpleName(), "@RequiresEnterpriseLicense and @RequiresEntitlement must not be present for Community category.");
        }
    }

    private void checkSelectOrCertified(@NotNull ClassTree classTree, boolean hasEnterpriseAnnotation, boolean hasEntitlementAnnotation) {
        if (!hasEnterpriseAnnotation || hasEntitlementAnnotation) {
            this.logAndRaiseIssue((Tree)classTree.simpleName(), "@RequiresEnterpriseLicense must be defined and @RequiresEntitlement must not be present for Select and Certified category.");
        }
    }

    private void checkPremium(@NotNull ClassTree classTree, List<? extends AnnotationTree> annotations, boolean hasEnterpriseAnnotation, boolean hasEntitlementAnnotation) {
        AnnotationTree annotation;
        Arguments arguments;
        ExpressionTree find;
        if (!hasEnterpriseAnnotation || !hasEntitlementAnnotation) {
            this.logAndRaiseIssue((Tree)classTree.simpleName(), "@RequiresEnterpriseLicense and @RequiresEntitlement need to be defined for Premium category.");
        }
        if (hasEntitlementAnnotation && (find = (ExpressionTree)Iterables.find((Iterable)(arguments = (annotation = (AnnotationTree)Iterables.find(annotations, HAS_REQUIRES_ENTITLEMENT_ANNOTATION)).arguments()), (Predicate)new Predicate<ExpressionTree>(){

            public boolean apply(@Nullable ExpressionTree input) {
                return input != null && input.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && "name".equals(((AssignmentExpressionTree)input).variable().toString());
            }
        }, null)) == null) {
            this.logAndRaiseIssue((Tree)classTree.simpleName(), "'name' attribute must be defined for @RequiresEntitlement using connector name.");
        }
    }
}

