/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringUtils;
import org.mule.tools.devkit.sonar.checks.java.AbstractConnectorClassCheck;
import org.mule.tools.devkit.sonar.checks.maven.Version;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="min-mule-version", name="Attribute 'minMuleVersion' should be declared in @Connector", description="Connectors should explicitly declare a 'minMuleVersion' inside @Connector, which is the minimum Mule version required. It must also follow the semantic versioning MAJOR.MINOR or MAJOR.MINOR.PATCH. For example, minMuleVersion = \"3.7\".", priority=Priority.CRITICAL, tags={"connector-certification"})
public class MinMuleVersionCheck
extends AbstractConnectorClassCheck {
    public static final String KEY = "min-mule-version";

    @Override
    protected void verifyConnector(ClassTree classTree) {
        for (AnnotationTree annotationTree : Iterables.filter((Iterable)classTree.modifiers().annotations(), ClassParserUtils.ANNOTATION_TREE_PREDICATE)) {
            if (!ClassParserUtils.is(annotationTree, "org.mule.api.annotations.Connector") || !Iterables.isEmpty((Iterable)annotationTree.arguments()) && !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)annotationTree.arguments(), f -> f.kind().name().equals("ASSIGNMENT") && ((IdentifierTree)((AssignmentExpressionTree)f).variable()).name().equals("minMuleVersion") && Version.hasValidFormat(StringUtils.replace((String)((LiteralTree)((AssignmentExpressionTree)f).expression()).token().text(), (String)"\"", (String)""))))) continue;
            this.logAndRaiseIssue((Tree)annotationTree, "@Connector should declare a 'minMuleVersion'.");
        }
    }
}

