/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.java;

import com.google.common.collect.Iterables;
import org.mule.tools.devkit.sonar.checks.java.BaseLoggingVisitor;
import org.mule.tools.devkit.sonar.utils.ClassParserUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="test-suite-annotations", name="Test Suite classes need to be annotated with @RunWith(Suite.class)", description="Test Suite classes need to be annotated with @RunWith(Suite.class)", priority=Priority.CRITICAL, tags={"connector-certification"})
public class TestSuiteCheck
extends BaseLoggingVisitor {
    public static final String KEY = "test-suite-annotations";

    public final void visitClass(ClassTree tree) {
        IdentifierTree treeName = tree.simpleName();
        if (treeName != null && treeName.name().endsWith("TestSuite")) {
            AnnotationTree runWithAnnotation = (AnnotationTree)Iterables.find((Iterable)tree.modifiers().annotations(), ClassParserUtils.hasAnnotationPredicate("org.junit.runner.RunWith"), null);
            if (runWithAnnotation == null) {
                this.logAndRaiseIssue((Tree)tree.simpleName(), String.format("Missing @RunWith annotation on Test Suite class '%s'.", tree.simpleName().name()));
            } else {
                Arguments arguments = runWithAnnotation.arguments();
                if (arguments.isEmpty()) {
                    this.logAndRaiseIssue((Tree)runWithAnnotation, String.format("Found @RunWith annotation on Test Suite class '%s', but no runner specified. It should be 'Suite.class'.", tree.simpleName().name()));
                } else {
                    ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement((Iterable)arguments);
                    if (argument.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                        MemberSelectExpressionTree memberSelectExpressionTree;
                        String fullyQualifiedClassName;
                        ExpressionTree expressionTree = ((MemberSelectExpressionTree)argument).expression();
                        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                            IdentifierTree identifierTree = (IdentifierTree)expressionTree;
                            if (!identifierTree.name().equals("Suite")) {
                                this.logAndRaiseIssue((Tree)runWithAnnotation, String.format("Found @RunWith annotation on Test Suite class '%s', but different runner specified ('%s.class' instead of '%s.class').", tree.simpleName().name(), identifierTree.name(), "Suite"));
                            }
                        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && !(fullyQualifiedClassName = ClassParserUtils.concatenate((ExpressionTree)(memberSelectExpressionTree = (MemberSelectExpressionTree)expressionTree))).equals("org.junit.runners.Suite")) {
                            this.logAndRaiseIssue((Tree)runWithAnnotation, String.format("Found @RunWith annotation on Test Suite class '%s', but different runner specified ('%s.class' instead of '%s.class').", tree.simpleName().name(), fullyQualifiedClassName, "Suite"));
                        }
                    }
                }
            }
        }
        super.visitClass(tree);
    }
}

