/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="demo-exist", name="Demo directory must be present", description="There must exist a directory named 'demos, and it should contain at least one directory containing a demo. That demo must have a README.md file describing the demo.'", priority=Priority.CRITICAL, tags={"connector-certification"})
public class DemoExistCheck
implements StructureCheck {
    public static final String KEY = "demo-exist";
    private static final DirectoryStream.Filter<Path> DIRECTORY_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path file) throws IOException {
            return Files.isDirectory(file, new LinkOption[0]);
        }
    };
    private final FileSystem fileSystem;

    public DemoExistCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        Path demosDir = this.fileSystem.baseDir().toPath().resolve("demo");
        if (!Files.exists(demosDir, new LinkOption[0]) || !demosDir.toFile().isDirectory()) {
            issues.add(new ConnectorIssue(KEY, "'demo' directory doesn't exist or it's a file rather than a directory."));
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(demosDir, DIRECTORY_FILTER);){
                ArrayList demos = Lists.newArrayList((Iterable)Iterables.filter(stream, (Predicate)new Predicate<Path>(){

                    public boolean apply(@Nullable Path input) {
                        return input != null && input.toFile().isDirectory();
                    }
                }));
                if (demos.isEmpty()) {
                    issues.add(new ConnectorIssue(KEY, "'demo' directory exists, but contains no demos."));
                } else {
                    for (Path demoDir : demos) {
                        this.checkReadmeMd(issues, demoDir);
                    }
                }
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return issues;
    }

    private void checkReadmeMd(List<ConnectorIssue> issues, Path demoDir) {
        if (!Files.exists(demoDir.resolve("README.md"), new LinkOption[0])) {
            issues.add(new ConnectorIssue(KEY, String.format("demo named '%s' is missing a README.md file explaining the purpose of the demo.", demoDir.getFileName())));
        }
    }
}

