/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.project.MavenProject;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.sonar.api.batch.fs.FileSystem;

public abstract class ExistingResourceCheck
implements StructureCheck {
    private final FileSystem fileSystem;

    public ExistingResourceCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        Path path = this.fileSystem.baseDir().toPath().resolve(this.resourcePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return ImmutableList.of((Object)new ConnectorIssue(this.ruleKey(), String.format("%s doesn't exist.", this.resourcePath())));
        }
        return ImmutableList.of();
    }

    protected abstract String resourcePath();

    protected abstract String ruleKey();

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

