/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.sonar.checks.structure;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.Nullable;
import org.mule.tools.devkit.sonar.checks.ConnectorIssue;
import org.mule.tools.devkit.sonar.checks.structure.StructureCheck;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.check.Priority;
import org.sonar.check.Rule;

@Rule(key="test-data-builder-exists", name="TestDataBuilder class should be present", description="There should exist a class named 'TestDataBuilder' in org.mule.modules.<connector-project>.automation.functional.TestDataBuilder.java", priority=Priority.MAJOR, tags={"connector-certification"})
public class TestDataBuilderExistsCheck
implements StructureCheck {
    public static final String KEY = "test-data-builder-exists";
    private static final String TEST_DATA_BUILDER_JAVA = "TestDataBuilder.java";
    private static final Pattern TEST_PACKAGES_PATTERN = Pattern.compile("^(.*?)(src/test/java/org/mule/module[s]?)+(/\\w+/)+(automation/functional)");
    private static final Predicate<File> IS_IN_AUTOMATION_PACKAGE = new Predicate<File>(){

        public boolean apply(@Nullable File input) {
            return input != null && TEST_PACKAGES_PATTERN.matcher(input.getPath()).find();
        }
    };
    private final FileSystem fileSystem;

    public TestDataBuilderExistsCheck(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Iterable<ConnectorIssue> analyze(MavenProject mavenProject) {
        ArrayList issues = Lists.newArrayList();
        Collection directories = FileUtils.listFiles((File)this.fileSystem.baseDir(), (IOFileFilter)new NameFileFilter(TEST_DATA_BUILDER_JAVA), (IOFileFilter)TrueFileFilter.INSTANCE);
        if (directories.isEmpty()) {
            issues.add(new ConnectorIssue(KEY, "TestDataBuilder.java doesn't exist."));
        } else if (!Iterables.any((Iterable)directories, IS_IN_AUTOMATION_PACKAGE)) {
            issues.add(new ConnectorIssue(KEY, String.format("TestDataBuilder.java exists, but it's not in the appropriate folder (%s). It must be located in 'org.mule.modules.<connector-project>.automation.functional.TestDataBuilder.java'.", directories.iterator().next())));
        }
        return issues;
    }
}

