/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is meant to be applied to support easy query building by using DataSense Query Language, <strong>DSQL</strong>.
 * This annotation must be defined within your @{@link Connector} scope.
 * <br/>
 * The parameter annotated with @{@link Query} can be either {@link String} or {@link org.mule.common.query.DsqlQuery}.
 * The latter is not recommended as it can break your connector compatibility.
 * <br/>
 * When an {@link String} parameter is annotated, you
 * can assume your query has been translated to your connector native query language by @{@link QueryTranslator}.
 * ie, the @{@link QueryTranslator} is required.
 * <br/>
 * On the other hand when an {@link org.mule.common.query.DsqlQuery} is annotated, you must do the translation within your processor.
 *
 *
 */
@Target({ElementType.PARAMETER})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Query {

  /**
   * Specify operators disabled in the displayed <strong>DSQL</strong> language.
   * This might be useful when your native language is smaller than <strong>DSQL</strong>.
   */
  QueryOperator[] disabledOperators() default {};

  /**
   * Limit feature is enabled or disabled
   */
  boolean limit() default true;


  /**
   * Offset feature is enabled or disabled
   */
  boolean offset() default true;


  /**
   * OrderBy feature is enabled or disabled
   */
  boolean orderBy() default true;
}
