/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.oauth;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation marks a method inside a {@link org.mule.api.annotations.oauth.OAuth} as the responsible for identifying
 * the user of an access token. It will be called by the connector's access token manager. This identification will be
 * used as a key to store access tokens.
 * <p/>
 * This annotation must be used on a non-static method without arguments and it must return a String which
 * contains the connection identifier representation.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
@Deprecated
public @interface OAuthAccessTokenIdentifier {

}
