/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.ws;


import java.lang.annotation.*;

/**
 * Responsible of returning a collection of WSDL files modeled through
 * {@link org.mule.devkit.api.ws.definition.ServiceDefinition}
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface WsdlServiceRetriever {

  /**
   * A String that will be used to work as a token separator between a WSDL and its operations. It cannot be empty String.
   * E.g.: Tshirt_ID#OrderTshirt, where Tshirt_IDis the WSDL and OrderTshirt the operation.
   */
  String keySeparator() default "||";

  /**
   * A list of string that maps to the values Studio will show for every drop down. The list's size must be either 2
   * (if retrieving a list of {@link org.mule.devkit.shade.ws.api.ServiceDefinition}) or 1 (if retrieving just one {@link org.mule.devkit.shade.ws.api.ServiceDefinition}).
   */
  String[] keyLabels() default {};
}
