/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation can be attached to any method also annotated with {@link org.mule.api.annotations.Processor} or
 * {@link org.mule.api.annotations.Source}. It receives a single argument which is the class of the exception to
 * be catch.
 * <p/>
 * If the exception is thrown by the Processor/Source it will automatically invalidate the connection.
 *
 * @deprecated Use {@link ReconnectOn} instead
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
@Deprecated
public @interface InvalidateConnectionOn {

  /**
   * The class of the exception that signals the invalidation of the connection
   */
  Class exception();
}
