/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The method annotated with {@link MetaDataRetriever} describes the metadata
 * for the received metadata key parameter.
 * <br/> An {@link org.mule.common.metadata.MetaDataKey} parameter is required and also the method return type must be {@link org.mule.common.metadata.MetaData}.
 * <br/>
 * <br/>
 * To build up this metadata we recommend using {@link org.mule.common.metadata.builder.DefaultMetaDataBuilder}.
 * For more information about {@link org.mule.common.metadata.MetaData} see {@link org.mule.common.metadata.MetaDataModel}.
 * <br/>
 * <br/>
 * <strong>Extra information</strong>
 * <ol>
 *  <li>This annotation must be used inside a @{@link org.mule.api.annotations.components.MetaDataCategory}
 *  <li>There must be an @{@link MetaDataKeyRetriever} method already defined.
 *  <li>When @{@link MetaDataOutputRetriever} is present at the same context this annotation
 *  will only work for input metadata.scenarios ONLY.
 * </ol>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface MetaDataRetriever {
}
