/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation marks a method inside a {@link Connector} as an operation that will return
 * a paged result set. Methods annotated with this interface must also be annotated with
 * {@link Processor} and must return an instance of {@link org.mule.streaming.ProviderAwarePagingDelegate}
 *
 * Parameters on this method will be featured as an attribute on the Mule XML invocation.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Paged {

  public static final int DEFAULT_FETCH_SIZE = 100;

  /**
   * Specifies the amount of elements to be retrieved on each invocation
   * to the data source. Defaults to 100.
   */
  int defaultFetchSize() default DEFAULT_FETCH_SIZE;

}
