/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * This annotation marks a method inside a {@link Connector} as a callable from within a Mule flow and capable of
 * generating Mule events. Each marked method will have a {@link org.mule.api.source.MessageSource} generated.
 * <p/>
 * The method must receive a {@link org.mule.api.callback.SourceCallback} as one of its arguments. It does not matter which parameter it is
 * as long it is there.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Source {

  /**
   * The xml name of the element that will invoke this source. This is optional and if it is not specified a name
   * will be derived from the name of the method.
   */
  String name() default "";

  /**
   * A user-friendly name for this processor.
   */
  String friendlyName() default "";

  /**
   * Does this message source must run on all cluster nodes, or just the primary one?
   */
  boolean primaryNodeOnly() default false;

  /**
   * Threading model
   */
  SourceThreadingModel threadingModel() default SourceThreadingModel.SINGLE_THREAD;

  /**
   * Message Source Strategy
   */
  SourceStrategy sourceStrategy() default SourceStrategy.NONE;

  /**
   * Polling period for SourceStrategy.POLLING.
   */
  long pollingPeriod() default -1L;
}
