/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.api.annotations.rest;

import org.mule.transformer.types.MimeTypes;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Used with the @Processor annotation. Indicates that upon invocation, the processor makes a RESTful request.
 * @deprecated for the Rest
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Deprecated
public @interface RestCall {

  /**
   * URI of the REST resource to query
   */
  String uri();

  /**
   * The content-type of the response from this method call.
   */
  String contentType() default MimeTypes.ANY;

  /**
   * The HTTP method to use
   */
  HttpMethod method() default HttpMethod.GET;

  /**
   *  List of exceptions to throw, configured by pairing an exception type and an expression which is evaluated.
   */
  RestExceptionOn[] exceptions() default {};
}
