/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Type;

public abstract class Op {
    private Op() {
    }

    static boolean hasTopOp(GeneratedExpression e) {
        return e instanceof UnaryOp || e instanceof BinaryOp;
    }

    public static GeneratedExpression minus(GeneratedExpression e) {
        return new UnaryOp("-", e);
    }

    public static GeneratedExpression not(GeneratedExpression e) {
        if (e == ExpressionFactory.TRUE) {
            return ExpressionFactory.FALSE;
        }
        if (e == ExpressionFactory.FALSE) {
            return ExpressionFactory.TRUE;
        }
        return new UnaryOp("!", e);
    }

    public static GeneratedExpression complement(GeneratedExpression e) {
        return new UnaryOp("~", e);
    }

    public static GeneratedExpression incr(GeneratedExpression e) {
        return new TightUnaryOp(e, "++");
    }

    public static GeneratedExpression decr(GeneratedExpression e) {
        return new TightUnaryOp(e, "--");
    }

    public static GeneratedExpression plus(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("+", left, right);
    }

    public static GeneratedExpression minus(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("-", left, right);
    }

    public static GeneratedExpression mul(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("*", left, right);
    }

    public static GeneratedExpression div(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("/", left, right);
    }

    public static GeneratedExpression mod(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("%", left, right);
    }

    public static GeneratedExpression shl(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("<<", left, right);
    }

    public static GeneratedExpression shr(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp(">>", left, right);
    }

    public static GeneratedExpression shrz(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp(">>>", left, right);
    }

    public static GeneratedExpression band(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("&", left, right);
    }

    public static GeneratedExpression bor(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("|", left, right);
    }

    public static GeneratedExpression cand(GeneratedExpression left, GeneratedExpression right) {
        if (left == ExpressionFactory.TRUE) {
            return right;
        }
        if (right == ExpressionFactory.TRUE) {
            return left;
        }
        if (left == ExpressionFactory.FALSE) {
            return left;
        }
        if (right == ExpressionFactory.FALSE) {
            return right;
        }
        return new BinaryOp("&&", left, right);
    }

    public static GeneratedExpression cor(GeneratedExpression left, GeneratedExpression right) {
        if (left == ExpressionFactory.TRUE) {
            return left;
        }
        if (right == ExpressionFactory.TRUE) {
            return right;
        }
        if (left == ExpressionFactory.FALSE) {
            return right;
        }
        if (right == ExpressionFactory.FALSE) {
            return left;
        }
        return new BinaryOp("||", left, right);
    }

    public static GeneratedExpression xor(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("^", left, right);
    }

    public static GeneratedExpression lt(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("<", left, right);
    }

    public static GeneratedExpression lte(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("<=", left, right);
    }

    public static GeneratedExpression gt(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp(">", left, right);
    }

    public static GeneratedExpression gte(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp(">=", left, right);
    }

    public static GeneratedExpression eq(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("==", left, right);
    }

    public static GeneratedExpression ne(GeneratedExpression left, GeneratedExpression right) {
        return new BinaryOp("!=", left, right);
    }

    public static GeneratedExpression _instanceof(GeneratedExpression left, Type right) {
        return new BinaryOp("instanceof", left, right);
    }

    public static GeneratedExpression cond(GeneratedExpression cond, GeneratedExpression ifTrue, GeneratedExpression ifFalse) {
        return new TernaryOp("?", ":", cond, ifTrue, ifFalse);
    }

    private static class TernaryOp
    extends AbstractExpression {
        String op1;
        String op2;
        GeneratedExpression e1;
        GeneratedExpression e2;
        GeneratedExpression e3;

        TernaryOp(String op1, String op2, GeneratedExpression e1, GeneratedExpression e2, GeneratedExpression e3) {
            this.e1 = e1;
            this.op1 = op1;
            this.e2 = e2;
            this.op2 = op2;
            this.e3 = e3;
        }

        @Override
        public void generate(Formatter f) {
            f.p('(').g(this.e1).p(this.op1).g(this.e2).p(this.op2).g(this.e3).p(')');
        }
    }

    private static class BinaryOp
    extends AbstractExpression {
        String op;
        GeneratedExpression left;
        Generable right;

        BinaryOp(String op, GeneratedExpression left, Generable right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public void generate(Formatter f) {
            f.p('(');
            if (this.left instanceof Assignment) {
                f.p('(').g(this.left).p(')');
            } else {
                f.g(this.left);
            }
            f.p(this.op).g(this.right).p(')');
        }
    }

    private static class TightUnaryOp
    extends UnaryOp {
        TightUnaryOp(GeneratedExpression e, String op) {
            super(e, op);
        }

        @Override
        public void generate(Formatter f) {
            if (this.opFirst) {
                f.p(this.op).g(this.e);
            } else {
                f.g(this.e).p(this.op);
            }
        }
    }

    private static class UnaryOp
    extends AbstractExpression {
        protected String op;
        protected GeneratedExpression e;
        protected boolean opFirst = true;

        UnaryOp(String op, GeneratedExpression e) {
            this.op = op;
            this.e = e;
        }

        UnaryOp(GeneratedExpression e, String op) {
            this.op = op;
            this.e = e;
            this.opFirst = false;
        }

        @Override
        public void generate(Formatter f) {
            if (this.opFirst) {
                f.p('(').p(this.op).g(this.e).p(')');
            } else {
                f.p('(').g(this.e).p(this.op).p(')');
            }
        }
    }
}

