/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.extension;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public abstract class ExtensionStructureGenerator {
    public static void copyProjectStructure(File srcDir, File extensionDir, Log logger, boolean excludeTests) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(srcDir.getAbsolutePath());
        directoryScanner.addDefaultExcludes();
        directoryScanner.setIncludes(new String[]{"**"});
        String[] excludes = new String[3];
        excludes[0] = "target/";
        excludes[1] = ".idea/";
        if (excludeTests) {
            excludes[2] = "src/test/java/";
        }
        directoryScanner.setExcludes(excludes);
        directoryScanner.scan();
        for (String filePath : directoryScanner.getIncludedFiles()) {
            File destination = new File(Paths.get(extensionDir.getAbsolutePath(), StringUtils.remove((String)filePath, (String)srcDir.getAbsolutePath())).toUri());
            ExtensionStructureGenerator.copyFile(new File(srcDir, filePath), destination, logger);
        }
    }

    private static void copyFile(File origin, File destination, Log logger) {
        if (!destination.exists()) {
            try {
                FileUtils.copyFile((File)origin, (File)destination);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error((CharSequence)e.getMessage());
            }
        }
    }
}

