/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.maven.extension.ExtensionPomGenerator;
import org.mule.devkit.maven.extension.ExtensionStructureGenerator;
import org.mule.devkit.maven.extension.InvokerCleanTask;

public abstract class AbstractAnnotationProcessorMojo
extends AbstractMuleMojo {
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(required=false)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/extension/", required=true)
    private File extensionDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=false)
    private File srcDirectory;
    @Parameter(required=false)
    private String compilerArguments;
    @Parameter(required=false)
    private Boolean addOutputDirectoryToCompilationSources;
    @Parameter(required=true, defaultValue="true", property="annotation.failOnError")
    private Boolean failOnError = true;
    @Parameter(required=true, defaultValue="true", property="annotation.outputDiagnostics")
    private boolean outputDiagnostics = true;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(required=false)
    private Map systemProperties;
    @Parameter(defaultValue="false", property="show.warnings")
    private boolean showWarnings;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="mule.devkit.version")
    private String devkitVersion;
    @Parameter(property="mule.extensions.parent.version")
    private String muleVersion;
    @Parameter(property="excludeTests", defaultValue="true")
    private boolean excludeTests;
    @Parameter(property="formatCode", defaultValue="true")
    private boolean formatCode;

    public abstract File getDefaultOutputDirectory();

    protected abstract File getOutputClassDirectory();

    protected abstract String[] getProcessors();

    protected abstract void addCompileSourceRoot(MavenProject var1, String var2);

    protected abstract Set<String> getClasspathElements(Set<String> var1);

    private String buildProcessor() {
        int i;
        if (this.getProcessors() == null || this.getProcessors().length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.getProcessors().length - 1; ++i) {
            result.append(this.getProcessors()[i]).append(',');
        }
        result.append(this.getProcessors()[i]);
        return result.toString();
    }

    private String buildCompileClasspath() {
        HashSet<String> jarPaths = new HashSet<String>();
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                File f;
                if (!"compile".equalsIgnoreCase(a.getScope()) && !"runtime".equalsIgnoreCase(a.getScope()) || (f = a.getFile()) == null) continue;
                jarPaths.add(a.getFile().getAbsolutePath());
            }
        }
        Set<String> classpathElements = this.getClasspathElements(new HashSet<String>());
        jarPaths.addAll(classpathElements);
        Set filteredJars = Sets.filter(jarPaths, (Predicate)new Predicate<String>(){

            public boolean apply(String jarName) {
                return !jarName.contains("jaxb-impl-");
            }
        });
        StringBuilder result = new StringBuilder();
        for (String jarPath : filteredJars) {
            result.append(jarPath).append(File.pathSeparator);
        }
        return result.toString();
    }

    public void execute() throws MojoExecutionException {
        block4: {
            this.getLog().info((CharSequence)this.getDMTLogo());
            if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
                return;
            }
            try {
                this.generateSources();
                this.updateProjectWithExtensionSources();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error on execute: " + e.getMessage()));
                if (this.verboseEnabled || e.getMessage().equals("java.lang.NullPointerException")) {
                    this.getLog().error((Throwable)e);
                    this.getLog().error((CharSequence)"please, report the whole stack as a bug in DevKit under http://forum.mulesoft.org/mulesoft after running \"mvn clean install -Ddevkit.verbose.enabled\"");
                }
                if (!this.failOnError.booleanValue()) break block4;
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private void generateSources() throws Exception {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getDefaultOutputDirectory();
        }
        this.ensureOutputDirectoryExists();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        ArrayList<File> filesToCompile = new ArrayList<File>(100);
        for (Object sourceDirectory : this.project.getCompileSourceRoots()) {
            File directory = new File((String)sourceDirectory);
            if (!directory.exists() || directory.equals(this.outputDirectory)) continue;
            filesToCompile.addAll(FileUtils.getFiles((File)directory, (String)includesString, (String)excludesString));
        }
        if (filesToCompile.isEmpty()) {
            this.getLog().warn((CharSequence)"no source file(s) detected! processor compilationTask will be skipped!");
            return;
        }
        List<String> options = this.getAnnotationProcessorCompileOptions();
        this.addCompilerArguments(options);
        this.setSystemProperties();
        this.callCompilationTask(compiler, fileManager, filesToCompile, options, "An error occurred while the DevKit was generating Java code. Check the logs for further details.");
    }

    private void updateProjectWithExtensionSources() throws MojoFailureException {
        ExtensionStructureGenerator.copyProjectStructure(this.project.getBasedir(), this.extensionDirectory, this.getLog(), this.excludeTests);
        try {
            ExtensionPomGenerator.generate(this.project.getBasedir(), this.extensionDirectory, this.formatCode);
            if (this.formatCode) {
                InvokerCleanTask.doClean(this.extensionDirectory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
    }

    private List<String> getAnnotationProcessorCompileOptions() {
        ArrayList<String> options = new ArrayList<String>(10);
        options.add("-cp");
        options.add(this.buildCompileClasspath());
        options.add("-proc:only");
        String processor = this.buildProcessor();
        if (processor != null) {
            options.add("-processor");
            options.add(processor);
        } else {
            this.getLog().info((CharSequence)"No processors specified. Using default discovery mechanism.");
        }
        options.add("-implicit:none");
        options.add("-g");
        options.add("-d");
        options.add(this.getOutputClassDirectory().getPath());
        options.add("-s");
        options.add(this.outputDirectory.getPath());
        if (this.encoding != null) {
            options.add("-encoding");
            options.add(this.encoding);
        }
        if (this.verboseEnabled) {
            options.add("-verbose");
            this.getLog().info((CharSequence)"Compiler Options:");
            for (String line : options) {
                this.getLog().info((CharSequence)line);
            }
        }
        return options;
    }

    private void callCompilationTask(JavaCompiler compiler, StandardJavaFileManager fileManager, List<File> filesToCompile, List<String> options, String message) throws Exception {
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(new PrintWriter(System.out), fileManager, this.createDiagnosticListener(), options, null, fileManager.getJavaFileObjectsFromFiles(filesToCompile));
        if (!compilationTask.call().booleanValue()) {
            this.getLog().error((CharSequence)message);
            this.getLog().info((CharSequence)"Use devkit.verbose.enabled to enable verbose mode");
            throw new Exception(message);
        }
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            Set pSet = this.systemProperties.entrySet();
            for (Map.Entry e : pSet) {
                this.getLog().info((CharSequence)String.format("set system property : [%s] = [%s]", e.getKey(), e.getValue()));
                System.setProperty((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private DiagnosticListener<JavaFileObject> createDiagnosticListener() {
        if (this.outputDiagnostics) {
            return new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    switch (diagnostic.getKind()) {
                        case ERROR: {
                            AbstractAnnotationProcessorMojo.this.getLog().error((CharSequence)diagnostic.toString().replace("error: ", "").replace("error on execute: ", ""));
                            break;
                        }
                        case WARNING: 
                        case MANDATORY_WARNING: {
                            AbstractAnnotationProcessorMojo.this.getLog().warn((CharSequence)diagnostic.toString().replace("warning: ", ""));
                            break;
                        }
                        case NOTE: {
                            String message = diagnostic.toString().replace("Note: ", "");
                            if (message.contains("DEBUG: ")) {
                                AbstractAnnotationProcessorMojo.this.getLog().debug((CharSequence)message.replace("DEBUG: ", ""));
                                break;
                            }
                            AbstractAnnotationProcessorMojo.this.getLog().info((CharSequence)message);
                            break;
                        }
                        case OTHER: {
                            AbstractAnnotationProcessorMojo.this.getLog().debug((CharSequence)diagnostic.toString());
                        }
                    }
                }
            };
        }
        return new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            }
        };
    }

    protected void addCompilerArguments(List<String> options) throws MojoExecutionException {
        if (!StringUtils.isEmpty((String)this.compilerArguments)) {
            for (String arg : this.compilerArguments.split(" ")) {
                if (StringUtils.isEmpty((String)arg)) continue;
                arg = arg.trim();
                this.getLog().info((CharSequence)("Adding compiler arg: " + arg));
                options.add(arg);
            }
        }
    }

    private void ensureOutputDirectoryExists() {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.getOutputClassDirectory().exists()) {
            this.getOutputClassDirectory().mkdirs();
        }
    }

    private String getDMTLogo() {
        return "\n__/\\\\\\\\\\\\\\\\\\\\\\\\______/\\\\\\\\____________/\\\\\\\\___/\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\_        \n _\\/\\\\\\////////\\\\\\___\\/\\\\\\\\\\\\________/\\\\\\\\\\\\__\\///////\\\\\\/////__       \n  _\\/\\\\\\______\\//\\\\\\__\\/\\\\\\//\\\\\\____/\\\\\\//\\\\\\________\\/\\\\\\_______      \n   _\\/\\\\\\_______\\/\\\\\\__\\/\\\\\\\\///\\\\\\/\\\\\\/_\\/\\\\\\________\\/\\\\\\_______     \n    _\\/\\\\\\_______\\/\\\\\\__\\/\\\\\\__\\///\\\\\\/___\\/\\\\\\________\\/\\\\\\_______    \n     _\\/\\\\\\_______\\/\\\\\\__\\/\\\\\\____\\///_____\\/\\\\\\________\\/\\\\\\_______   \n      _\\/\\\\\\_______/\\\\\\___\\/\\\\\\_____________\\/\\\\\\________\\/\\\\\\_______  \n       _\\/\\\\\\\\\\\\\\\\\\\\\\\\/____\\/\\\\\\_____________\\/\\\\\\________\\/\\\\\\_______ \n        _\\////////////______\\///______________\\///_________\\///________\n";
    }
}

