/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.extension;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ExtensionPomGenerator {
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    private static String VERSION_NODE = "version";
    private static String ARTIFACT_ID_NODE = "artifactId";
    private static String GROUP_ID_NODE = "groupId";
    private static String PACKAGING_ID_NODE = "packaging";
    private static String EXTENSION_PACKAGING = "mule-extension";

    public static void generate(File projectBasedir, File extensionDirectory, boolean formatCode) {
        try {
            Document pom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(projectBasedir.getPath().concat("/pom.xml"));
            ExtensionPomGenerator.updateParent(pom);
            ExtensionPomGenerator.updatePackaging(pom);
            ExtensionPomGenerator.clearPlugins(pom);
            if (formatCode) {
                ExtensionPomGenerator.addFormatter(pom);
            }
            ExtensionPomGenerator.clearProperties(pom);
            ExtensionPomGenerator.clearDependencies(pom);
            ExtensionPomGenerator.export(extensionDirectory, pom);
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong while generating the extension pom.xml file");
        }
    }

    private static void updatePackaging(Document pom) throws XPathExpressionException {
        pom.getDocumentElement().getElementsByTagName(PACKAGING_ID_NODE).item(0).setTextContent(EXTENSION_PACKAGING);
    }

    private static void clearDependencies(Document pom) throws Exception {
        Node dependenciesNode = (Node)xpath.evaluate("//project/dependencies", pom.getDocumentElement(), XPathConstants.NODE);
        if (dependenciesNode == null) {
            dependenciesNode = pom.createElement("dependencies");
            pom.getDocumentElement().appendChild(dependenciesNode);
        }
        dependenciesNode.appendChild(ExtensionPomGenerator.getDevkitShade(pom));
    }

    private static Node getDevkitShade(Document pom) {
        Element shade = pom.createElement("dependency");
        Element groupId = pom.createElement(GROUP_ID_NODE);
        groupId.setTextContent("org.mule.tools.dmt");
        shade.appendChild(groupId);
        Element artifact = pom.createElement(ARTIFACT_ID_NODE);
        artifact.setTextContent("mule-devkit-shade");
        shade.appendChild(artifact);
        Element version = pom.createElement(VERSION_NODE);
        version.setTextContent("0.9.1");
        shade.appendChild(version);
        return shade;
    }

    private static void clearPlugins(Document pom) throws XPathExpressionException {
        Node devkitMavenPlugin = (Node)xpath.evaluate("//plugins/plugin/artifactId[text()=\"mule-devkit-maven-plugin\"]", pom.getDocumentElement(), XPathConstants.NODE);
        if (devkitMavenPlugin != null) {
            devkitMavenPlugin.getParentNode().getParentNode().removeChild(devkitMavenPlugin.getParentNode());
        }
    }

    private static void addFormatter(Document pom) throws XPathExpressionException {
        if (xpath.evaluate("//plugins/plugin/artifactId[text()=\"formatter-maven-plugin\"]", pom.getDocumentElement(), XPathConstants.NODE) != null) {
            return;
        }
        Element formatter = pom.createElement("plugin");
        Element gid = pom.createElement(GROUP_ID_NODE);
        gid.setTextContent("net.revelc.code.formatter");
        formatter.appendChild(gid);
        Element aid = pom.createElement(ARTIFACT_ID_NODE);
        aid.setTextContent("formatter-maven-plugin");
        formatter.appendChild(aid);
        Element ver = pom.createElement(VERSION_NODE);
        ver.setTextContent("2.7.1");
        formatter.appendChild(ver);
        Element es = pom.createElement("executions");
        Element e = pom.createElement("execution");
        Element phase = pom.createElement("phase");
        phase.setTextContent("clean");
        Element goals = pom.createElement("goals");
        Element goal = pom.createElement("goal");
        goal.setTextContent("format");
        goals.appendChild(goal);
        e.appendChild(goals);
        e.appendChild(phase);
        es.appendChild(e);
        formatter.appendChild(es);
        Node plugins = (Node)xpath.evaluate("//plugins", pom.getDocumentElement(), XPathConstants.NODE);
        if (plugins != null) {
            plugins.appendChild(formatter);
        }
    }

    private static void clearProperties(Document pom) throws Exception {
        Node skipNode;
        Node jdkVersion = (Node)xpath.evaluate("//properties/jdk.version", pom.getDocumentElement(), XPathConstants.NODE);
        if (jdkVersion != null) {
            Node parentNode = jdkVersion.getParentNode();
            parentNode.removeChild(jdkVersion);
        }
        if ((skipNode = (Node)xpath.evaluate("//properties/devkit.studio.package.skip", pom.getDocumentElement(), XPathConstants.NODE)) != null) {
            skipNode.getParentNode().removeChild(skipNode);
        }
    }

    private static void updateParent(Document pom) throws XPathExpressionException {
        Node parentNode = pom.getDocumentElement().getElementsByTagName("parent").item(0);
        ((Node)xpath.evaluate("//parent/groupId", parentNode, XPathConstants.NODE)).setTextContent("org.mule.extensions");
        ((Node)xpath.evaluate("//parent/artifactId", parentNode, XPathConstants.NODE)).setTextContent("mule-modules-parent");
        ((Node)xpath.evaluate("//parent/version", parentNode, XPathConstants.NODE)).setTextContent("1.1.0");
    }

    private static void export(File extensionDirectory, Document pom) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(pom), new StreamResult(new File(extensionDirectory, "pom.xml")));
    }
}

