/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;

public class MetaDataProperties {
    private Set<MetaDataField> fields;

    public MetaDataProperties(Set<MetaDataField> fields) {
        this.fields = fields;
    }

    public MetaDataProperties() {
        this(new TreeSet<MetaDataField>(new MetaDataFieldComparator()));
    }

    public Set<MetaDataField> getFields() {
        return this.fields;
    }

    public void add(MetaDataField field) {
        this.fields.add(field);
    }

    public void addAll(MetaDataProperties properties) {
        this.fields.addAll(properties.fields);
    }

    public Map<String, MetaDataModel> toMap() {
        HashMap<String, MetaDataModel> result = new HashMap<String, MetaDataModel>();
        for (MetaDataField field : this.fields) {
            result.put(field.getName(), field.getMetaDataModel());
        }
        return result;
    }

    public MetaDataField getFieldByName(String name) {
        for (MetaDataField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean removeFieldByName(String name) {
        for (MetaDataField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            this.fields.remove(field);
            return true;
        }
        return false;
    }

    private static class MetaDataFieldComparator
    implements Comparator<MetaDataField> {
        private MetaDataFieldComparator() {
        }

        @Override
        public int compare(MetaDataField field1, MetaDataField field2) {
            return field1.getName().compareTo(field2.getName());
        }
    }
}

