/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.HttpRetriever;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.mule.common.metadata.XmlMetaDataFieldFactory;
import org.mule.common.metadata.util.PathUtilities;

public class XmlSchemaUtils {
    public static SchemaTypeSystem getSchemaTypeSystem(List<String> schemas) throws XmlException {
        return XmlSchemaUtils.getSchemaTypeSystem(schemas, null);
    }

    public static SchemaTypeSystem getSchemaTypeSystem(List<String> schemas, URL source, HttpRetriever retriever) throws XmlException {
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        if (source != null) {
            options.put((Object)"DOCUMENT_SOURCE_NAME", (Object)source.toString());
            try {
                options.put((Object)"BASE_URI", (Object)new URI(PathUtilities.extractDirectoryPath(source.toString())));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        XmlObject[] schemaRepresentation = new XmlObject[schemas.size()];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build((SchemaTypeLoader[])new SchemaTypeLoader[]{XmlBeans.getBuiltinTypeSystem()}, null, (ClassLoader)XmlMetaDataFieldFactory.class.getClassLoader());
        for (int i = 0; i < schemas.size(); ++i) {
            schemaRepresentation[i] = contextTypeLoader.parse(schemas.get(i), null, options);
        }
        return SchemaTypeSystemCompiler.compile(null, null, (XmlObject[])schemaRepresentation, null, (SchemaTypeLoader)contextTypeLoader, null, (XmlOptions)options);
    }

    public static SchemaTypeSystem getSchemaTypeSystem(List<String> schemas, URL source) throws XmlException {
        return XmlSchemaUtils.getSchemaTypeSystem(schemas, source, null);
    }

    public static SchemaTypeSystem getSchemaTypeSystemFromUrl(List<URL> schemas) throws XmlException, IOException {
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        XmlObject[] schemaRepresentation = new XmlObject[schemas.size()];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build((SchemaTypeLoader[])new SchemaTypeLoader[]{XmlBeans.getBuiltinTypeSystem()}, null, (ClassLoader)XmlMetaDataFieldFactory.class.getClassLoader());
        int i = 0;
        for (URL schemaURL : schemas) {
            XmlObject schemaObject;
            schemaRepresentation[i] = schemaObject = contextTypeLoader.parse(schemaURL, null, options);
            ++i;
        }
        return SchemaTypeSystemCompiler.compile(null, null, (XmlObject[])schemaRepresentation, null, (SchemaTypeLoader)contextTypeLoader, null, (XmlOptions)options);
    }
}

