/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.mule.tools.maven.exchange.VersioningStrategyType;
import org.mule.tools.maven.exchange.api.ExchangeApi;
import org.mule.tools.maven.exchange.api.ExchangeApiVersion;
import org.mule.tools.maven.exchange.api.ExchangeObject;
import org.mule.tools.maven.exchange.api.ExchangeObjectType;
import org.mule.tools.maven.exchange.api.Version;
import org.mule.tools.maven.exchange.core.ProjectAnalyzer;
import org.mule.tools.maven.exchange.core.ProjectPublisher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.xml.sax.SAXException;

@Mojo(name="add")
public class AddMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component(hint="mng-4384")
    private SecDispatcher secDispatcher;
    @Parameter(name="anypointUsername", required=true, readonly=true, property="anypointUsername")
    private String anypointUsername;
    @Parameter(name="anypointPassword", required=true, readonly=true, property="anypointPassword")
    private String anypointPassword;
    @Parameter(name="nameUrl", required=true, readonly=true, property="nameUrl")
    private String nameUrl;
    @Parameter(name="objectType", required=true, readonly=true, property="objectType")
    private ExchangeObjectType objectType;
    @Parameter(name="versioningStrategy", defaultValue="incremental", readonly=true, property="versioningStrategy")
    private VersioningStrategyType versioningStrategy;
    @Parameter(name="muleRuntimeVersion", readonly=true, property="muleRuntimeVersion")
    private String muleRuntimeVersion;
    @Parameter(name="anypointUri", defaultValue="https://anypoint.mulesoft.com", readonly=true, property="anypointUri")
    private String anypointUri;
    @Parameter(name="exchangeApiVersion", defaultValue="v16", readonly=true, property="exchangeApiVersion")
    private ExchangeApiVersion exchangeApiVersion;
    @Parameter(name="businessGroup", required=true, readonly=true, property="businessGroup")
    private String businessGroup;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ExchangeApi exchangeApi = new ExchangeApi(this.anypointUri, this.getLog(), this.anypointUsername, this.anypointPassword, this.exchangeApiVersion, this.businessGroup);
        try {
            exchangeApi.init();
            ExchangeObject exchangeObject = new ExchangeObject();
            this.setupMandatoryValues(exchangeObject);
            this.setupCurrentVersion(exchangeObject);
            this.setupExtraInformation(exchangeObject);
            ProjectPublisher.upsertExchangeObject(exchangeApi, exchangeObject, this.versioningStrategy, this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (SAXException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void setupMandatoryValues(ExchangeObject exchangeObject) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Getting mandatory values from Project...");
        exchangeObject.setName(ProjectAnalyzer.obtainName(this.mavenProject, this.getLog()));
        exchangeObject.setNameUrl(this.nameUrl);
        exchangeObject.setOwner(this.anypointUsername);
        exchangeObject.setTypeId(this.objectType.id());
        this.getLog().info((CharSequence)("Exchange Name Url: " + this.nameUrl));
        this.getLog().info((CharSequence)("Exchange Owner: " + this.anypointUsername));
        this.getLog().info((CharSequence)("Exchange Object type: " + (Object)((Object)this.objectType)));
    }

    private void setupCurrentVersion(ExchangeObject exchangeObject) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<Version> versions = new ArrayList<Version>();
        Version version = new Version();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Getting current version values from Project...");
        String downloadUrl = ProjectAnalyzer.obtainDownloadUrl(this.mavenProject, this.getLog());
        if (!exchangeObject.getTypeId().equals(ExchangeObjectType.connector.id())) {
            version.setDownloadUrl(downloadUrl);
            version.setDocUrl(ProjectAnalyzer.obtainDocUrl(this.mavenProject, this.getLog()));
            version.setObjectVersion(ProjectAnalyzer.obtainVersion(this.mavenProject, this.getLog()));
            version.setMuleVersionId(ProjectAnalyzer.obtainMuleRuntimeVersion(this.mavenProject, this.getLog(), this.muleRuntimeVersion));
        } else {
            version = ProjectAnalyzer.obtainConnectorVersionFromArtifact(this.mavenProject, this.getLog(), this.settings, this.secDispatcher, downloadUrl);
        }
        versions.add(version);
        exchangeObject.setVersions(versions);
    }

    private void setupExtraInformation(ExchangeObject exchangeObject) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Getting extra information from Project...");
        exchangeObject.setDescription(ProjectAnalyzer.obtainDescription(this.getLog()));
    }
}

