/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.exchange.api.ExchangeApiVersion;
import org.mule.tools.maven.exchange.api.ExchangeAuthorizationResponse;
import org.mule.tools.maven.exchange.api.ExchangeObject;
import org.mule.tools.maven.exchange.api.User;
import org.mule.tools.maven.exchange.api.cs.AbstractMuleApi;
import org.mule.tools.maven.exchange.api.cs.ApiException;

public class ExchangeApi
extends AbstractMuleApi {
    private static final String EXCHANGE_TOKEN_HEADER = "x-token";
    private static final String EXCHANGE_TOKEN_PATH = "/exchange/api/exchangeToken";
    private static final String EXCHANGE_TOKEN_REQUEST_TEMPLATE = "{  \"access_token\": \"%s\"  }";
    private String exchangeToken;
    private User user;
    private ExchangeApiVersion exchangeApiVersion;

    public ExchangeApi(String uri, Log log, String username, String password, ExchangeApiVersion exchangeApiVersion, String businessGroup) {
        super(uri, log, username, password, businessGroup);
        this.exchangeApiVersion = exchangeApiVersion;
    }

    @Override
    public void init() throws IOException {
        super.init();
        try {
            this.exchangeToken = this.obtainExchangeToken();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExchangeObject updateExchangeObject(ExchangeObject exchangeObject) throws ApiException, IOException {
        Entity json;
        ObjectMapper mapper = new ObjectMapper();
        String object_path = this.exchangeApiVersion.buildExchangeObjectsPath(this, exchangeObject);
        Response response = this.put(this.uri, object_path, json = Entity.json((Object)mapper.writeValueAsString((Object)exchangeObject)));
        if (response.getStatus() == 200) {
            return (ExchangeObject)mapper.readValue((String)response.readEntity(String.class), ExchangeObject.class);
        }
        throw new ApiException(response);
    }

    public ExchangeObject createExchangeObject(ExchangeObject exchangeObject) throws ApiException, IOException {
        Entity json;
        ObjectMapper mapper = new ObjectMapper();
        String object_path = this.exchangeApiVersion.buildExchangeObjectsPath(this, exchangeObject);
        Response response = this.post(this.uri, object_path, json = Entity.json((Object)mapper.writeValueAsString((Object)exchangeObject)));
        if (response.getStatus() == 201) {
            return (ExchangeObject)mapper.readValue((String)response.readEntity(String.class), ExchangeObject.class);
        }
        throw new ApiException(response);
    }

    public ExchangeObject getExchangeObject(ExchangeObject exchangeObject) throws ApiException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String object_path = this.exchangeApiVersion.buildExchangeObjectsDomainPath(this);
        Response response = this.get(this.uri, object_path = object_path + "/" + exchangeObject.getNameUrl());
        if (response.getStatus() == 200) {
            return (ExchangeObject)mapper.readValue((String)response.readEntity(String.class), ExchangeObject.class);
        }
        if (response.getStatus() == 404) {
            return null;
        }
        throw new ApiException(response);
    }

    public ExchangeObject deleteExchangeObject(ExchangeObject exchangeObject) throws ApiException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String object_path = this.exchangeApiVersion.buildExchangeObjectsPath(this, exchangeObject);
        Response response = this.delete(this.uri, object_path);
        if (response.getStatus() == 200) {
            return (ExchangeObject)mapper.readValue((String)response.readEntity(String.class), ExchangeObject.class);
        }
        throw new ApiException(response);
    }

    public void requestForPublishing(ExchangeObject exchangeObject) throws ApiException, IOException {
        String object_path = this.exchangeApiVersion.buildExchangeObjectsPath(this, exchangeObject);
        Entity json = Entity.json((Object)"{ }");
        Response response = this.post(this.uri, object_path + "/publishingRequest", json);
        if (response.getStatus() != 200) {
            throw new ApiException(response);
        }
    }

    private String obtainExchangeToken() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String json_string = String.format(EXCHANGE_TOKEN_REQUEST_TEMPLATE, this.bearerToken);
        Entity json = Entity.json((Object)json_string);
        Response response = this.post(this.uri, EXCHANGE_TOKEN_PATH, json);
        if (response.getStatus() == 200) {
            ExchangeAuthorizationResponse authorizationResponse = (ExchangeAuthorizationResponse)mapper.readValue((String)response.readEntity(String.class), ExchangeAuthorizationResponse.class);
            this.user = authorizationResponse.getUser();
            return authorizationResponse.getToken();
        }
        throw new ApiException(response);
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        super.configureRequest(builder);
        builder.header(EXCHANGE_TOKEN_HEADER, (Object)("Bearer " + this.exchangeToken));
    }

    public User getUser() {
        return this.user;
    }
}

