/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange.api.cs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.tools.maven.exchange.api.cs.AbstractApi;
import org.mule.tools.maven.exchange.api.cs.ApiException;
import org.mule.tools.maven.exchange.api.cs.AuthorizationResponse;
import org.mule.tools.maven.exchange.api.cs.UserInfo;

public abstract class AbstractMuleApi
extends AbstractApi {
    private static final String ME = "/accounts/api/me";
    private static final String LOGIN = "/accounts/login";
    private static final String UUID_PATTERN_MATCHER = "^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    private String username;
    private String password;
    protected String uri;
    protected String environment;
    protected final String businessGroup;
    protected String bearerToken;
    protected String orgId;

    public AbstractMuleApi(String uri, Log log, String username, String password, String businessGroup) {
        super(log);
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.businessGroup = businessGroup;
    }

    public void init() throws IOException {
        this.bearerToken = this.getBearerToken(this.username, this.password);
        this.orgId = this.getOrgId();
    }

    private String getBearerToken(String username, String password) throws IOException {
        Pattern pattern = Pattern.compile(UUID_PATTERN_MATCHER);
        Matcher matcher = pattern.matcher(password);
        if (matcher.find()) {
            return password;
        }
        ObjectMapper mapper = new ObjectMapper();
        Entity json = Entity.json((Object)("{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}"));
        Response response = this.post(this.uri, LOGIN, json);
        this.validateStatusSuccess(response);
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)mapper.readValue((String)response.readEntity(String.class), AuthorizationResponse.class);
        return authorizationResponse.getAccessToken();
    }

    protected void validateStatusSuccess(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ApiException(response);
        }
    }

    public String getOrgId() {
        Pattern pattern = Pattern.compile(UUID_PATTERN_MATCHER);
        Matcher matcher = pattern.matcher(this.businessGroup);
        if (matcher.find()) {
            return this.businessGroup;
        }
        return this.findBusinessGroup();
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        }
        if (this.orgId != null) {
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    private JSONObject getHierarchy() {
        UserInfo response = this.get(this.uri, ME, UserInfo.class);
        String rootOrgId = response.user.organization.getId();
        return new JSONObject(this.get(this.uri, "accounts/api/organizations/" + rootOrgId + "/hierarchy", String.class));
    }

    public String findBusinessGroup() {
        String currentOrgId = null;
        String[] groups = this.createBusinessGroupPath();
        JSONObject json = this.getHierarchy();
        JSONArray subOrganizations = (JSONArray)json.get("subOrganizations");
        if (groups.length == 0) {
            return (String)json.get("id");
        }
        if (json.get("name").equals(groups[0])) {
            currentOrgId = (String)json.get("id");
        }
        for (int group = 0; group < groups.length; ++group) {
            for (int organization = 0; organization < subOrganizations.length(); ++organization) {
                JSONObject jsonObject = (JSONObject)subOrganizations.get(organization);
                if (!jsonObject.get("name").equals(groups[group])) continue;
                currentOrgId = (String)jsonObject.get("id");
                subOrganizations = (JSONArray)jsonObject.get("subOrganizations");
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((String)this.businessGroup)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroup.length() - 1; ++i) {
            if (this.businessGroup.charAt(i) == '\\') {
                if (this.businessGroup.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroup.charAt(i);
        }
        if (i < this.businessGroup.length()) {
            group = group + this.businessGroup.charAt(this.businessGroup.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }
}

