/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.tools.maven.exchange.api.Version;
import org.mule.tools.maven.exchange.core.Utils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.xml.sax.SAXException;

public class ProjectAnalyzer {
    public static String obtainName(MavenProject mavenProject, Log log) {
        log.info((CharSequence)("Project Name: " + mavenProject.getName()));
        return mavenProject.getName();
    }

    public static String obtainVersion(MavenProject mavenProject, Log log) {
        log.info((CharSequence)("Exchange Object version: " + mavenProject.getVersion()));
        return mavenProject.getVersion();
    }

    public static String obtainMuleRuntimeVersion(MavenProject mavenProject, Log log, String muleRuntimeVersionParameter) {
        log.info((CharSequence)"Attempting to get Mule Runtime version from 'mule.version' property...");
        String runtimeVersion = mavenProject.getProperties().getProperty("mule.version");
        if (runtimeVersion == null) {
            log.info((CharSequence)"'mule.version' not found, using 'muleRuntimeVersion' parameter");
            runtimeVersion = muleRuntimeVersionParameter;
        } else {
            Pattern pattern = Pattern.compile("^([0-4]\\.[0-9]+).*$");
            Matcher matcher = pattern.matcher(runtimeVersion);
            runtimeVersion = matcher.find() ? matcher.group(1) : muleRuntimeVersionParameter;
        }
        log.info((CharSequence)("Mule Version ID: " + runtimeVersion));
        return runtimeVersion;
    }

    public static String obtainDescription(Log log) {
        String description;
        try {
            log.info((CharSequence)"Attempting to get Description from README.md file");
            description = FileUtils.readFileToString((File)new File("README.md"));
            log.info((CharSequence)"Found README.md file, loading Description");
        }
        catch (IOException e) {
            log.info((CharSequence)"README.md file not found, setting Description placeholder");
            description = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec dolor mauris, rutrum ut suscipit ac, rutrum ut felis. Fusce dignissim vestibulum augue, ut eleifend tellus fringilla sed. Sed auctor pharetra tortor nec ultrices. Praesent eget volutpat nunc, quis gravida dolor. Sed tempus dignissim pharetra. Suspendisse potenti. Aenean sit amet massa convallis nunc euismod molestie.";
        }
        return description;
    }

    public static String obtainDownloadUrl(MavenProject mavenProject, Log log) {
        if (mavenProject.getDistributionManagement() != null) {
            String downloadUrl = mavenProject.getDistributionManagement().getRepository().getUrl() + mavenProject.getDistributionManagementArtifactRepository().pathOf(mavenProject.getArtifact());
            Pattern pattern = Pattern.compile("^(.*).mule$");
            Matcher matcher = pattern.matcher(downloadUrl);
            if (matcher.find()) {
                downloadUrl = matcher.group(1) + ".zip";
            }
            log.info((CharSequence)("Version Download URL: " + downloadUrl));
            return downloadUrl;
        }
        log.info((CharSequence)"Version Download URL: not found");
        return null;
    }

    public static String obtainDocUrl(MavenProject mavenProject, Log log) {
        File readme;
        if (mavenProject.getScm() != null && (readme = new File("README.md")).exists()) {
            String connectionUrl = mavenProject.getScm().getConnection();
            Pattern pattern = Pattern.compile("^scm:git:(.*github\\.com.*)\\.git.*$");
            Matcher matcher = pattern.matcher(connectionUrl);
            if (matcher.find()) {
                String docUrl = matcher.group(1) + "/blob/" + mavenProject.getScm().getTag() + "/" + "README.md";
                log.info((CharSequence)("Version Doc URL: " + docUrl));
                return docUrl;
            }
        }
        log.info((CharSequence)"Version Doc URL: not found");
        return null;
    }

    public static Version obtainConnectorVersionFromArtifact(MavenProject mavenProject, Log log, Settings settings, SecDispatcher secDispatcher, String downloadUrl) throws IOException, ParserConfigurationException, SAXException {
        String password;
        Server server = settings.getServer(mavenProject.getDistributionManagement().getRepository().getId());
        String username = server.getUsername();
        try {
            password = secDispatcher.decrypt(server.getPassword());
        }
        catch (SecDispatcherException e) {
            throw new IOException(e.getMessage());
        }
        File tmpFolder = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        String artifactFilePath = tmpFolder + File.separator + UUID.randomUUID().toString() + ".zip";
        Utils.downloadFile(downloadUrl, artifactFilePath, username, password);
        HashMap<String, String> connectorAttributes = Utils.parseConnectorArtifact(artifactFilePath, tmpFolder);
        Version version = new Version();
        version.setFeatureId(connectorAttributes.get("featureId"));
        version.setMuleVersionId(connectorAttributes.get("minMuleVersion"));
        version.setApiVersion(connectorAttributes.get("notes"));
        version.setObjectVersion(connectorAttributes.get("connectorVersion"));
        log.info((CharSequence)("Feature ID: " + version.getFeatureId()));
        log.info((CharSequence)("Min Mule Version: " + version.getMuleVersionId()));
        log.info((CharSequence)("Notes: " + version.getApiVersion()));
        log.info((CharSequence)("Connector version: " + version.getObjectVersion()));
        return version;
    }
}

