/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange.core;

import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.maven.exchange.VersioningStrategyType;
import org.mule.tools.maven.exchange.api.ExchangeApi;
import org.mule.tools.maven.exchange.api.ExchangeObject;

public class ProjectPublisher {
    public static void upsertExchangeObject(ExchangeApi exchangeApi, ExchangeObject exchangeObject, VersioningStrategyType versioningStrategy, Log log) throws IOException {
        log.info((CharSequence)"");
        log.info((CharSequence)"Checking if Project already exists in Exchange...");
        ExchangeObject currentExchangeObject = exchangeApi.getExchangeObject(exchangeObject);
        if (currentExchangeObject != null) {
            log.info((CharSequence)"");
            log.info((CharSequence)"Project found in Exchange, updating versions...");
            ExchangeObject finalExchangeObject = ProjectPublisher.mergeExchangeObjectsForUpdate(currentExchangeObject, exchangeObject, versioningStrategy);
            ExchangeObject updatedExchangeObject = exchangeApi.updateExchangeObject(finalExchangeObject);
            if (!currentExchangeObject.getState().equals(updatedExchangeObject.getState())) {
                exchangeApi.requestForPublishing(updatedExchangeObject);
            }
            log.info((CharSequence)"Project successfully updated");
        } else {
            log.info((CharSequence)"");
            log.info((CharSequence)"Project not found in Exchange, creating new entry...");
            exchangeObject.setOrganizationId(exchangeApi.getOrgId());
            exchangeApi.createExchangeObject(exchangeObject);
            log.info((CharSequence)"Project successfully created");
        }
    }

    private static ExchangeObject mergeExchangeObjectsForUpdate(ExchangeObject currentExchangeObject, ExchangeObject newExchangeObject, VersioningStrategyType versioningStrategy) {
        currentExchangeObject.setVersions(versioningStrategy.mergeVersions(currentExchangeObject.getVersions(), newExchangeObject.getVersions()));
        return currentExchangeObject;
    }
}

